label day3:
    window auto hide
    with dissolve
    show bg workshop

    $ renpy.music.play("audio/daily-coffee-upbeat-lofi-groove-242099.mp3", fadein=2.0, loop=True)


    # Leo's enthusiastic introduction
    show trainer happy at trainer_transform()
    trainer "Good morning, everyone!"
    trainer "I hope you had your morning coffee, because you will need plenty of brain juice and energy to dive into the amazing world of European opportunities for youth."
    trainer "It’s my favourite topic, woohoo!"

    # Leo's awkward smile
    show trainer happy at trainer_transform()
    show blush_overlay at trainer_transform(), fade_in_blush(0.5), zorder 2 
    trainer "Eh, yes, I am quite the nerd when it comes to Europe."

    # Leo explains the session plan
    show trainer neutral at trainer_transform()
    hide blush_overlay
    trainer "But fear not: I won’t be giving you a big lecture on these (seriously amazing) programmes."
    trainer "I will pitch you the main opportunities I think you should know about, and then we will explore these opportunities through a sort of speed dating."
    trainer "We start in pairs, and change partners every 5 minutes. I’ll participate, so you’ll have the opportunity to ask more details about specific programmes if you want!"

    # First Player Choice
    menu:
        "Sounds booooriiiing…":
            $ punk_relation_value += 1
            show punk neutral at punk_transform(0.3)
            show up arrow as arrow at  up_arrow_anim(centerX, centerY, 0.3, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show trainer sad at trainer_transform()
            trainer "Oh… Well, you signed up for this training, so there’s no escape now! Hehe."
            hide arrow
            hide punk
        
        "Alright then, let’s do our best to follow!":
            $ engineer_relation_value += 1
            show engineer neutral at engineer_transform(0.3)
            show up arrow as arrow at  up_arrow_anim(centerX, centerY, 0.3, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show trainer happy at trainer_transform()
            trainer "That’s the spirit!"
            hide arrow
            hide engineer
        
        "You could have turned it into a song, I’m sure you can pull it off!":
            $ marketeer_relation_value += 1
            show marketeer neutral at marketeer_transform(0.2)
            show up arrow as arrow1 at  up_arrow_anim(centerX, centerY, 0.2, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ activist_relation_value += 1
            show activist neutral at activist_transform(0.4)
            show up arrow as arrow2 at  up_arrow_anim(centerX, centerY, 0.4, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show trainer laughing at trainer_transform()
            trainer "Haha, good one! Joke’s on you, I’m a terrible singer though. I’m sure you all prefer if I don’t sing."
            hide arrow1
            hide arrow2
            hide marketeer
            hide activist

    # Leo continues the presentation
    show trainer:
        pass

    show trainer presentation1 at trainer_presentation1()
    trainer "Okay, so let’s dive into it!"
    trainer "I’m going to focus on 2 programmes that each have several actions or specific branches within them."
    trainer "The choice was hard, so I decided to present the actions that you and me, as youth, could take part in directly."

    
    trainer "The first programme is…"
    show trainer:
        pass
    show trainer neutral at trainer_transform()
    trainer "…Wait, I’m sure you’ve heard of it. Can you guess?"


    # Guessing the programme name
    menu:
        "Student exchange":
            show trainer neutral at trainer_transform()
            trainer "Ah, student exchanges are part of what I wanted you to guess. Does anybody have an idea of the name of the programme that is part of?"

            show engineer neutral at engineer_transform(0.3)
            engineer "Isn’t it Erasmus?"

            show trainer happy at trainer_transform()
            trainer "Yes! It’s 'Erasmus+', to be exact!"
            
            hide engineer
            jump continueafterchoice

        "Erasmus":
            show trainer laughing at trainer_transform()
            trainer "Yes! It’s the programme that funds our youth exchange this week. The complete name is 'Erasmus+'."
            jump continueafterchoice

        "Erasmus+":
            show trainer laughing at trainer_transform()
            trainer "Bingo! You got it right directly. Good job on remembering the '+' in 'Erasmus+'!"
            jump continueafterchoice

        "Uh?":
            show trainer laughing at trainer_transform()
            trainer "Haha, someone should have had more coffee!"

            show activist happy at activist_transform(0.3)
            activist "Someone did just follow their BFF for the holidays, right?"

            hide activist
            jump secondchoice

label secondchoice:
    # Second guessing choices
    menu:
        "Uh?? What?":
            show trainer happy at trainer_transform()
            trainer "Haha, it’s 'Erasmus+'! You might have seen the logo on this week’s programme. But nevermind, I wanted to ping you a bit."

        "…Am I supposed to know…?":
            show trainer happy at trainer_transform()
            trainer "Haha, it’s 'Erasmus+'! You might have seen the logo on this week’s programme. But nevermind, I wanted to ping you a bit."

        "Wait… Is it 'Erasmus' or something?":
            show trainer happy at trainer_transform()
            trainer "Haha, it’s 'Erasmus+'! You might have seen the logo on this week’s programme. But nevermind, I wanted to ping you a bit."

label continueafterchoice:
    # Leo explains Erasmus+
    show trainer happy at trainer_transform()
    trainer "So, yes, Erasmus+ is the first main programme I wanted to present today."
 
    show trainer neutral at trainer_transform()
    trainer "It is probably best known for student exchanges, although there’s much more than that."
    trainer "Also, it’s not just exchanges for university students, but I’m getting ahead of myself."

    show trainer:
        pass

    show trainer presentation1 at trainer_presentation1()
    trainer "To start with, I’ll present from Erasmus+ what we are doing this week!"
    trainer "Together, we are part of what is called a Youth Exchange from the Erasmus+ programme."

    show trainer:
        pass

    show trainer happy at trainer_transform()
    trainer "To quote the European Commission: ‘Youth exchanges allow groups of young people from different countries to meet, live together and work on shared projects for short periods’."
    trainer "It lasts for 5 to 21 days, and you can expect to take part in different types of activities."

    show trainer neutral at trainer_transform()
    trainer "This week we’re a bit “classroom-y”, and we have debates and discussions, but others focus on outdoor activities."
    trainer "The goal is really to meet and explore ideas together on a common topic."

    jump whatnext


label whatnext:
    # Asking what to hear about next
    menu:
        
        trainer "What do you want to hear about next?"

        "DiscoverEU" if discovereu_counter < 1:
            $ discovereu_counter += 1
            show trainer happy at trainer_transform()
            trainer "Ok, good choice! This is a new initiative from the programme."
            trainer "It consists in giving a free travel pass to selected people the year they turn 18, and only for this year."
            trainer "In 2024, 35000 youths were selected! The goal is to help many people discover Europe’s culture and diversity."
            
            show trainer neutral at trainer_transform()
            trainer "You can travel mostly by train, but for better accessibility ferries and buses are accepted exceptionally."
            trainer "No planes though, it aims to be an climate-friendly programme!"

            # DiscoverEU follow-up choices
            menu:
                "Cool! Do I have to do anything specific while I’m travelling?":
                    show trainer happy at trainer_transform()

                "Sounds nice, but I wouldn’t know what to do…":
                    show trainer happy at trainer_transform()

                "How’s that related to climate change?":
                    show trainer happy at trainer_transform()
        
            trainer "Another cool aspect of DiscoverEu is that you can apply and travel as a group of up to 5 people."
            trainer "Also, on the European Youth Portal, you can get suggestions for different themes to organise your visits."

            show trainer:
                pass
            show trainer presentation1 at trainer_presentation1()

            trainer "There is even a Green Route map, which lists European Green capitals and other places that implement outstanding actions for the environment that you could witness yourself!"
            
            show trainer:
                pass
            show trainer neutral at trainer_transform()

            jump whatnext

        "Training opportunities" if training_counter < 1 :
            $ training_counter += 1

            show trainer:
                pass
            show trainer presentation1 at trainer_presentation1()

            trainer "Youth trainings can be similar to youth exchanges in terms of format and duration, but you do have a fixed learning programme."

            # Training opportunities follow-up choices
            menu:
                "Ok, do you have any examples?":
                    show trainer:
                        pass
                    show trainer neutral at trainer_transform()

                "Err, I don’t have a clear picture…":
                    show trainer:
                        pass
                    show trainer neutral at trainer_transform()

                "How is that related to green skills?":
                    show trainer:
                        pass
                    show trainer neutral at trainer_transform()

            trainer "To give you a concrete example: last year, I went for one week to a rural town in Poland, where an NGO taught us how to create games to teach young people about climate change."
            trainer "It was really cool because we each created our scenario during the training, and I tested it with a few groups when I got home."
            jump whatnext

        "Youth participation activities" if participation_counter < 1 :
            $ participation_counter += 1
            show trainer neutral at trainer_transform()
            trainer "This is all about making youth’s voice heard and making a change. It can range from local to European levels."

            # Youth participation follow-up choices
            menu:
                "Great! What could I do in practice?":
                    show trainer neutral at trainer_transform()

                "It sounds very political, but not very practical…":
                    show trainer neutral at trainer_transform()

                "That’s a lot to take in…":
                    show trainer neutral at trainer_transform()
        
            show trainer surprised at trainer_transform()
            trainer "Ooooh, that’s a serious answer! This is all about making youth’s voice heard and making a change."
            
            show trainer happy at trainer_transform()
            trainer "The formats can vary greatly, but they can cover a wide range of activities at the local, national or European level."
            show trainer neutral at trainer_transform()
            trainer "For instance, some like to start working at the local level before going bigger."
            trainer "You don’t have to be part of an organisation to apply: you can even be an informal group of young people."
            show trainer happy at trainer_transform()
            trainer "Say, if we wanted to apply for one together at the end of the week, we could!"
            jump whatnext

    # Leo finishes the Erasmus+ presentation
    show trainer happy at trainer_transform()
    trainer "Phew! Okay, that’s all for Erasmus+. One last programme to go. Are you still with me?"

    # Reactions from other characters
    hide trainer
    hide bg workshop
    show bg opposite
    show engineer happy at engineer_transform(0.2)
    engineer "Yeah, sure!"
    show activist happy at activist_transform(0.35)
    activist "Hell yeah, I’ve got so many ideas!"
    show marketeer happy at marketeer_transform(-0.2)
    marketeer "Cool! I’ve got one or two ideas myself…"
    show punk neutral at punk_transform(-0.35)
    punk "Mmpf…"
    show bestfriend neutral at bestfriend_transform()
    bestfriend "Carry on!"

    hide trainer
    hide engineer
    hide marketeer
    hide punk
    hide bestfriend
    hide activist
    show bg workshop
    show trainer happy at trainer_transform()
    # Final Player Choice
    menu:
        "Ugh this is so boring!":
            $ punk_relation_value += 1
            hide trainer
            show bg opposite
            show punk neutral at punk_transform(0.3)
            show up arrow as arrow at  up_arrow_anim(centerX, centerY, 0.3, 0)
            play oneshots "audio/wind-chime-small-64660.mp3"
            punk "Yeah, sounds very bureaucratic…"
            hide arrow
            hide punk
            show bg workshop
            show trainer sad at trainer_transform()
            trainer "Well, the day’s only starting, maybe you’ll change your mind!"

        "I had no idea there was so much we could do. And you’re telling us there’s more?!":
            $ activist_relation_value += 1
            hide trainer
            show bg opposite
            show activist happy at activist_transform(0.3)
            show up arrow as arrow at  up_arrow_anim(centerX, centerY, 0.3, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            activist "You shouldn’t have said that: now I’m gonna have to flood you with all my ideas!"
            hide arrow
            hide activist
            show bg workshop
            show trainer happy at trainer_transform()
            trainer "Yeah, that’s the spirit! Now, for the last programme: buckle up, buttercup!"

        "I’ll need another coffee, but I’m following!":
            $ engineer_relation_value += 1
            hide trainer
            show bg opposite
            show engineer happy at engineer_transform(0.3)
            show up arrow as arrow at  up_arrow_anim(centerX, centerY, 0.3, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            engineer "Science does say that a cup of coffee improves cognitive abilities!"
            hide arrow
            hide engineer
            show bg workshop
            show trainer laughing at trainer_transform()
            trainer "Yeah, but don’t drink too much or you’ll end up having labrador energy like me!"

        "I guess it will make sense when we discuss the details.":
            $ marketeer_relation_value += 1
            hide trainer
            show bg opposite
            show marketeer neutral at marketeer_transform(0.3)
            show up arrow as arrow at  up_arrow_anim(centerX, centerY, 0.3, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            marketeer "I’m a bit confused on some parts myself, but I can definitely see a few things happening in these actions."
            hide arrow
            hide marketeer
            show bg workshop
            show trainer happy at trainer_transform()
            trainer "Yeah, these programs are like an oven, but you bring the ingredients and make the recipe."

    menu:
        "Ok, go on!":
            jump next
        "Let’s try to survive this last programme, then!":
            jump next

label next:    
    # Trainer introduces the final program
    show trainer neutral at trainer_transform()
    trainer "So, last but not least: you simply have to know about the European Solidarity Corps!"
    trainer "The European Solidarity Corps brings together young people to build a more inclusive society, supporting vulnerable people and responding to societal challenges."

    hide trainer
    show bg opposite
    show activist happy at activist_transform(-0.3)
    activist "In English, please?"
    hide activist
    show bg workshop
    show trainer happy at trainer_transform()
    trainer "Ok, let’s see the practice. So, you can either volunteer in a project or create your own."
    trainer "There are volunteering projects, solidarity projects, and humanitarian aid outside the European Union."
    trainer "You can get involved in these projects as an individual for 2 to 12 months in all 3 branches, and also take part in short-term activities as a group for 2 weeks to 2 months in volunteering and humanitarian aid projects."
    
    # Leo explains the difference between project types in the European Solidarity Corps
    show trainer neutral at trainer_transform()
    trainer "The main difference is that Solidarity projects are mainly for actions in your country, humanitarian aid is necessarily outside of your country, and volunteering projects are for cross-border actions usually in another country than the one you reside in."
    trainer "In each programme, you receive funding. For volunteering and humanitarian aid projects, your travel, accommodation, and food are covered, and you receive a supplementary personal allowance."
    trainer "In solidarity projects, you can expect €630 a month to cover the cost of managing and implementing the project."

    # Taylor and Riley ask questions
    hide trainer
    show bg opposite
    show marketeer happy at marketeer_transform(-0.3)
    marketeer "Nice! What are the different fields?"

    show punk surprised at punk_transform(0.3)
    punk "Yeah, how is that related to the environment?"


    hide marketeer
    hide punk
    show bg workshop
    # Leo answers with enthusiasm
    show trainer happy at trainer_transform()
    trainer "Glad you’re asking! While the field of environment and natural protection is targeted, it can also be tackled in other fields, such as creativity and culture, education and training, employment and entrepreneurship, disaster prevention and recovery, for instance."
    trainer "As climate change has an impact on all aspects of our lives and society, even actions outside of the field of the environment and natural protection could relate to it."

    # Alex asks for clarification
    hide trainer
    show bg opposite
    show engineer neutral at engineer_transform(-0.3)
    engineer "Ok, so it’s quite large, right?"

    hide engineer
    show bg workshop
    show trainer happy at trainer_transform()
    trainer "Indeed it is!"

    # Activity conclusion
    show trainer neutral at trainer_transform()
    trainer "But hey, I’ve already spoken a lot, and I’m sure your minds are buzzing with information right now. How about a short break?"


    hide bg workshop
    hide trainer
    show bg opposite

    # Characters agree to take a break
    show marketeer neutral at marketeer_transform(-0.25), zorder 0
    show engineer neutral at engineer_transform(-0.4), zorder 1
    show activist neutral at activist_transform()
    show bestfriend neutral at bestfriend_transform(0.17)
    show punk neutral at punk_transform(0.35)

    engineer "Ok!"
    marketeer "Ok!"
    activist "Ok!"
    bestfriend "Sounds good!"
    punk "Yes, please..."

    scene black with fade

    window auto hide
    with dissolve
    show bg aerial:
        subpixel True 
        offset (0.0, 0.0) zoom 1.0 
    $ renpy.pause(1)
    scene black with fade





label speed_dating_sessions:
    window auto hide
    with dissolve
    # Set background and music
    show bg workshop
    $ renpy.music.play("audio/luxury-summer-fall-travel-vlog-lofi-hip-hop-253485.mp3", fadein=2.0, loop=True)

    show trainer happy at trainer_transform()
    trainer "Ok, hope you all had a nice break. Let’s get back to our ‘speed dating’ sessions! Discuss what these programmes and actions could mean to you."
    
    tuto "[[Each character picks a piece of paper with a name in a sorting hat. Your first speed meeting is with…]"
    hide trainer
    jump speed_dating_choice

label speed_dating_choice:

    if sessions_counter >= 4:
        jump leo_stops_session

    # Initial player choice for first speed dating session
    menu:
        "Riley" if punk_session_counter < 1 :
            jump punk_rejection_institutions
        "Alex" if engineer_session_counter < 1 :
            jump engineer_optimism_science_policy
        "Taylor" if marketeer_session_counter < 1 :
            jump taylor_conversation
        "Sam" if bestfriend_session_counter < 1 :
            $ bestfriend_session_counter += 1
            show bestfriend happy at bestfriend_transform()
            bestfriend "We’ll talk on the way home. Pick someone else!"
            hide bestfriend
            jump speed_dating_choice
        "Jade" if activist_session_counter < 1 :
            jump activist_internal_conflict

label punk_rejection_institutions:
    $ punk_session_counter += 1
    if sessions_counter < 1:
        $ punk_relation_value += 1
        show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0), zorder 2

        play oneshots "audio/wind-chime-small-64660.mp3"
    $ sessions_counter += 1
    # Riley's reaction to EU programs
    show punk neutral at punk_transform()
    punk "Hey! Look, I’m not in a great mood. I mean: the EU? Seriously?"
    show punk angry2 at punk_transform()
    punk "No way. I’m not taking a single cent from those bureaucrats."
    punk "I’ve been running the eco-hostel independently for years, and yeah, it’s tough, but at least we’re not tied to some institutional nonsense."
    punk "Once they’ve got their hooks in you, you can kiss your freedom goodbye."
    hide arrow
    # Player choices to influence relationship with Riley
    menu:
        "I get it, independence is important. But maybe working with them could help you grow the project without losing control.":
            $ punk_relation_value += 2
            "I totally understand where you’re coming from. Independence is key, right? But imagine what you could do if you had access to more resources and still kept control. Maybe it’s not about giving up your freedom, but about making your impact even bigger."
            show punk neutral at punk_transform()
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            punk "Yeah… I guess I could see that, if it meant not giving up what matters. Still, I’ve got to be careful, but I get what you’re saying."

        "But wouldn’t more funding help? Think of what you could do with the extra resources.":
            $ punk_relation_value += 1
            "I get why you’re hesitant, but with more funding, you could really expand the eco-hostel and reach more people. It doesn’t have to be about selling out. It’s about doing more of what you love."
            show punk neutral at punk_transform()
            punk "Yeah, I hear you. But I’m not about to trade my freedom for a bigger project. Maybe I’ll think about it… if I can stay in control."

        "Honestly, Riley, you’re making it harder on yourself for no reason. Maybe it’s time to stop being so stubborn.":
            $ punk_relation_value += 0
            "Look, I get that independence matters, but you’re making things harder for yourself. It’s not all or nothing. Maybe it’s time to stop being so stubborn and see the bigger picture."
            show punk angrycrossed at punk_transform()
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            punk "Stubborn? I’m fighting for what I believe in, not playing it safe like everyone else. Maybe you don’t get what real independence means."

    hide arrow
    # Program suggestion for Riley
    tuto "[[What European programme do you think Riley could take part in?]"

    menu:
        "Since you have a farm and an eco-hostel, maybe you could host a volunteering activity?":
            $ punk_relation_value += 2
            show punk neutral at punk_transform()
            show up arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            punk "Oh, that was the European Solidarity Corps, wasn’t it? Well, I can’t get away from the farm and the hostel for too long, so it could be a way to meet like-minded Europeans… Not a bad idea!"

        "An Erasmus+ Youth Participation Activity could be nice to discuss eco-farming, no?":
            $ punk_relation_value += 0
            show punk neutral at punk_transform()
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            punk "Technically, I guess. But I’m more interested in a hands-on approach rather than in debates."

        "Maybe you could volunteer for a few months on another farm as part of the European Solidarity Corps, and learn from others' experience?":
            $ punk_relation_value += 1
            show punk neutral at punk_transform()
            punk "That’s at least for 2 weeks or 2 months, right? It’s too long for me to be away from the crops, it’s hard for me to find a replacement… I only managed to come to this exchange because my cousin was free and knows her way around the farm."
    
    hide arrow
    # Transition to next partner
    tuto "[[The timer rings, signalling you to change partners. Next, you pick…]"
    hide punk
    jump speed_dating_choice

label engineer_optimism_science_policy:
    $ engineer_session_counter += 1
    if sessions_counter < 1:
        $ engineer_relation_value += 1
        show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

        play oneshots "audio/wind-chime-small-64660.mp3"
    $ sessions_counter += 1

    # Alex's view on EU programs and science
    show engineer neutral at engineer_transform()
    engineer "Wow, that’s a bit intense, right?"

    hide arrow
    # First player choice for reaction
    menu:
        "I think I’m starting to get the hang of it all…":
            $ engineer_relation_value += 1
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
        
        "I’m just glad the presentation stopped!":
            $ engineer_relation_value -= 1
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"

    
    # Alex shares thoughts
    show engineer neutral at engineer_transform()
    engineer "These EU programs are exactly what we need. It’s a real chance to scale up smaller projects and make a bigger impact."
    hide arrow
    engineer "Those volunteering opportunities can be a great way for everyone to get acquainted with science–it’s how I started."
    engineer "I don’t understand why people like Riley and Jade are so resistant. The science is clear."

    # Player choices to influence relationship with Alex
    menu:
        "I agree, science is essential. But people in tough situations aren’t always driven by facts. It’s hard to think about data when you’re struggling to get by.":
            $ engineer_relation_value += 2
            "I totally get it—science is the foundation. But when people are struggling just to survive or when they’re deeply tied to their community’s way of thinking, data doesn’t always resonate."
            "It’s hard to focus on facts when you’re worried about making ends meet."
            show engineer neutral at engineer_transform()
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            engineer "You’re right… I tend to think of everything in terms of facts and evidence."
            engineer "But you can’t expect people to prioritize data when they’re just trying to survive. Maybe there’s more to communicating science than just presenting the facts."

        "You’ve got a point, but I think Riley and Jade are more worried about control. People don’t trust big systems when they’ve been burned before.":
            $ engineer_relation_value += 1
            "I get where you’re coming from, but I think Riley and Jade are more concerned about losing control."
            "A lot of people don’t trust institutions, especially when they’ve been burned in the past. It’s not just about the science—it’s about trust."
            show engineer neutral at engineer_transform()
            engineer "Yeah, I can see that. It’s frustrating, though, because the science is so clear. But I guess if people don’t trust the system, they won’t even listen to the data."

        "You know, not everything can be solved with data, Alex. People have emotions, cultures, and lives that don’t fit neatly into scientific models.":
            $ engineer_relation_value -= 2
            "Science is important, but it doesn’t solve everything. People have emotions, cultures, and ways of living that don’t fit neatly into scientific models. It’s not always about the numbers."
            show engineer neutral2 at engineer_transform()
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            engineer "I understand that people have emotions and cultures, but the problems we’re facing are about the numbers."
            engineer "If we let feelings and cultural resistance guide us, we’ll never make the changes we need. The data is there for a reason."

    hide arrow
    # Narration about the European program discussion with Alex
    tuto "[[What European programme would you like to talk about with Alex?]"

    # Player choices for discussion topic
    menu:
        "Oh, you volunteered? What did you do?":
            $ engineer_relation_value += 1
            show engineer happy at engineer_transform()
            engineer "Oh, you want to know? Well, here goes! I volunteered in a European Solidarity Corps project in which we studied turtles’ nesting!"
            engineer "I basically spent a month on a kayak gathering samples. We also prepared the beach to make it safe for the turtles!"
            show engineer sad at engineer_transform()
            engineer "Actually… While getting some sand samples, I was careless and I almost damaged a nest…"
            show engineer neutral at engineer_transform()
            engineer "It’s what got me into science. I want to know how to mitigate the effects of climate change on biodiversity."
            engineer "I’m sure there’s a way we can all support nature if we only learn more about the science of it."

        "Have you considered DiscoverEU? Travelling around Europe sounds nice!":
            $ engineer_relation_value += 0
            show engineer happy at engineer_transform()
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            engineer "It sure does, but I’ve just turned 19!"
            engineer "I asked Leo during the break, and you really have to be 18 at the time of travelling."
            engineer "But there are plenty of other opportunities."
            engineer "Leo told me the Joint Research Center accepts interns: they provide the science to inform EU policy, it sounds perfect for me!"

        "Volunteering as a group with the European Solidarity Corps could be nice. You could show Taylor what science looks like in real life, I’m sure he’d like that.":
            $ engineer_relation_value += 2
            show engineer surprised at engineer_transform()
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            engineer "Huh, Taylor? Why do you mention him?"
            show engineer neutral at engineer_transform()
            show blush_engineer_overlay at engineer_transform(), fade_in_blush(0.5), zorder 2 
            engineer "I mean, sure… I guess it would be a nice opportunity… To show him interesting science stuff he could communicate about, of course…"
            hide blush_engineer_overlay
    hide arrow
    # End of session
    tuto "[[Beep beep! Time to change partners. Next, you pick…]"
    hide engineer
    jump speed_dating_choice  # Replace with label for remaining options as needed



label taylor_conversation:
    $ marketeer_session_counter += 1
    if sessions_counter < 1:
        $ marketeer_relation_value += 1
        show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

        play oneshots "audio/wind-chime-small-64660.mp3"
    $ sessions_counter += 1
    # Taylor's initial excitement about EU programs
    show marketeer happy at marketeer_transform()
    marketeer "Wow, I’m so pumped up! These EU programs are a total goldmine!"
    marketeer "I mean, think about it—we can get funding, platforms, and all the visibility we need to really blow up our campaigns."
    marketeer "The exposure alone could take things to the next level. Riley and Jade are missing out—they’re too focused on their ideals to see the opportunity here."
    hide arrow
    # Player choices to influence relationship with Taylor
    menu:
        "It’s a great opportunity, but it’s not just about visibility. What message are you amplifying?":
            $ marketeer_relation_value += 2
            "I totally agree—it’s a huge opportunity for visibility. But you’ve got to think about the message you’re amplifying. What do you want people to really take away from it?"
            show marketeer neutral at marketeer_transform()
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            marketeer "Yeah… I guess you’re right. It’s not just about getting attention, it’s about what we’re saying."
            marketeer "I should focus more on that. What’s the point of visibility if the message isn’t solid?"

        "You’re right, the exposure is amazing. But don’t you think people will see through it if it’s just for show?":
            $ marketeer_relation_value += 1
            "You’re right, the exposure is amazing. But if it’s just about the visibility and not the message, don’t you think people will see through it?"
            "They’ll notice if it’s all for show."
            show marketeer sad at marketeer_transform()
            marketeer "Yeah, I guess that makes sense. People are pretty good at picking up on when something’s fake."
            marketeer "I need to make sure the message is real, not just the image."

        "Taylor, this isn’t just about exposure. You’re focusing too much on yourself and not the cause.":
            $ marketeer_relation_value += 0
            "Taylor, I get that you’re excited about the exposure, but you’re focusing way too much on yourself and not enough on the cause."
            "This isn’t just about building your brand, it’s about making a real difference."
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            show marketeer angry at marketeer_transform()
            marketeer "I’m not just doing this for myself! It’s about getting the message out there… but yeah, I do want people to see it."
            marketeer "What’s the point if no one’s watching?"

    hide arrow
    # Program suggestion for Taylor
    tuto "What European programme do you think Taylor could benefit from?"

    menu:
        "DiscoverEU sounds like the perfect fit for you: you communicate about the programme, local green initiatives, and show how to travel green!":
            $ marketeer_relation_value += 0
            show marketeer happy at marketeer_transform()
            marketeer "Not a bad idea. I do prefer group activities though, I need to talk to someone."
            marketeer "But group travel is an option, so I guess it could work."

        "Youth Participation Activities could help you go to the next level in spreading awareness about climate change.":
            $ marketeer_relation_value += 1
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show marketeer happy at marketeer_transform()
            marketeer "I definitely want to get into Youth Participation Activities. I don’t mind leading it, even."
            marketeer "But I’d like to get a bit more mature on the topic of climate change."
            marketeer "Seeing how Alex gets fired up with science stuff, I’m guessing I should slow down a bit to learn more about that."
            marketeer "I could even share that knowledge with others in my awareness raising activities."

        "You could talk Alex into building a group for volunteering in the European Solidarity Corps. She could show you why science is so important to her.":
            $ marketeer_relation_value += 2

            marketeer "About Alex… I’m such an open book, right? You saw right through me!"
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show marketeer happy at marketeer_transform()
            show blush_marketeer_overlay at marketeer_transform(), fade_in_blush(1), zorder 2
            marketeer "Look, I am starting to have a crush on her."
            marketeer "I’m not a big science guy, but I like her fire: she makes me curious as to why she’s so into it."
            marketeer "More seriously though, you’re right: taking part in scientific initiatives could definitely broaden my horizons, and give me plenty of things to communicate about. Good call!"
            show marketeer happy at marketeer_transform()
            hide blush_marketeer_overlay
            marketeer "Hey, since we’re there… Do you have a crush on someone?"
    hide arrow
    # Player choice for romantic interest reveal
    menu:
        "Who, me? No…":
            show marketeer happy at marketeer_transform()
            marketeer "You won’t say? Haha, alright."

        "Not really":
            show marketeer happy at marketeer_transform()
            marketeer "That’s fair, it’s only been a few days."

        "I have a crush on Jade":
            show marketeer happy at marketeer_transform()
            marketeer "Oh, you like passionate people too, don’t you?"

        "I really like Riley":
            show marketeer surprised at marketeer_transform()
            marketeer "Quite the charismatic beast, eh?"

        "Alex is kinda cool…":
            show marketeer neutral at marketeer_transform()
            marketeer "Guess I can’t blame you."

        "You’re quite nice…":
            show marketeer surprised at marketeer_transform()
            marketeer "Look, I’m flattered, but… Hmpf, that’s awkward…"
    hide arrow
    # Transition to the next scene
    tuto "[[Beep beep! Time to change partners. Next, you pick…]"
    hide marketeer
    jump speed_dating_choice



label activist_internal_conflict:

    $ activist_session_counter += 1
    if sessions_counter < 1:
        $ activist_relation_value += 1
        show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

        play oneshots "audio/wind-chime-small-64660.mp3"
    $ sessions_counter += 1


    # Scene setup with Jade approaching the MC
    show activist neutral at activist_transform()
    activist "Hey, doing ok?"

    # First player choice
    menu:
        "Yeah":
            show activist happy at activist_transform()
            activist "At least one of us is, haha!"

        "I’m barely surviving…":
            show activist happy at activist_transform()
            activist "Haha, it’s a lot to take in, right?"

    # Jade expresses her inner conflict
    show activist sad at activist_transform()
    activist "It made me think about a lot of initiatives that could receive some financing."
    activist "The EU could actually help fund some of the campaigns we’ve been struggling to launch."
    activist "But it feels… I don’t know… like I’d be compromising my values, getting tangled up in their system."
    activist "What do you think? Should we really be trusting the EU to fund radical change?"

    # Second player choice influencing relationship with Jade
    menu:
        "If it helps the cause, maybe it’s worth considering. You can still stay true to your values.":
            $ activist_relation_value += 3
            "I get why you’re hesitant, but if the funding helps push your cause forward, isn’t it worth considering?"
            "As long as you stay true to your values, the money doesn’t have to change who you are or what you stand for."
            show activist afraid_surprised at activist_transform()
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            activist "You’re right… I could make sure the resources don’t shift the message."
            activist "Maybe it’s not about selling out—it’s about using what’s available to fight harder. I appreciate your take on this."

        "Honestly, I think you’re overthinking it. You’ve always been about passion and action. This is just how you are.":
            $ activist_relation_value += 0
            "Honestly, Jade, I think you’re overthinking this."
            "You’ve always been about passion and action—that’s your strength. You’ve never been one to worry about systems and processes."
            "Just stick with what you’re good at, you know?"
            show activist afraid_surprised at activist_transform()
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            activist "Is that how you see me? Someone who just runs on passion without thinking?"
            activist "I’m trying to expand my approach here, but you’re telling me to stay in my lane. That’s not what I needed to hear."

        "It’s tricky, but maybe you could look into it and see if it feels right? No harm in exploring.":
            $ activist_relation_value += 1
            "I get why you’re conflicted. It’s tricky."
            "But maybe there’s no harm in exploring it? You could look into what they offer, and if it doesn’t feel right, you can always say no."
            show activist neutral at activist_transform()
            activist "Yeah… you’re right. I could check it out, but keep my guard up. No harm in looking into it, I guess."

        "Honestly, I don’t think you’re cut out for dealing with bureaucracy. It’s not really your thing, right?":
            $ activist_relation_value += 0
            "Honestly? I don’t see you navigating all that bureaucracy."
            "It’s not really your thing."
            "You’re more of an on-the-ground kind of person, out there making things happen in real time. Why bother with EU programs when you know that’s not your style?"
            show activist sad at activist_transform()
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            activist "Wow… thanks for the vote of confidence."
            show activist angry at activist_transform()
            activist "You think I can’t adapt? I get that passion drives me, but I’m not some mindless activist running on feelings alone."
            activist "I’m trying to think bigger now, and you’re just telling me to stay stuck in that box?"

    # Follow-up question on EU programs
    tuto "[[Can you think of a programme that Jade might be interested in?]"

    hide arrow
    # Player presents ideas to Jade
    menu:
        tuto "[[Can you think of a programme that Jade might be interested in?]"

        "You could apply as a group for short-term European Solidarity Corps volunteering. Free trip for 2 weeks with your friends!":
            show activist angry at activist_transform()
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            activist "Look, I want to have a long-lasting impact. I’m not here on holidays."

        "Youth Participation Activities sound perfect for you. You could make the voice of youth heard in politics and have an impact, without compromising on your ideas.":
            $ activist_relation_value += 2
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show activist happy at activist_transform()
            activist "Yeah, I was thinking about it too."
            activist "I like that this programme is all about making all voices heard."
            activist "It might also teach me how to work with a wider variety of people: either people our age who have different views, or politicians."
            activist "Ideals are one thing, but I have to learn to talk to everyone, not just preach to the choir."

        "I think you could share your experience and broaden your views in other youth exchanges. You really bring the fire to the debate.":
            $ activist_relation_value += 1
            show activist neutral at activist_transform()
            activist "I guess it wouldn’t hurt. The more people you meet, the more you learn how to make an impact."

    hide arrow
    # Transition back to the training room
    show activist neutral at activist_transform()
    activist "Ok, time to change partners."
    hide activist
    jump speed_dating_choice

label leo_stops_session:
    
    scene black with fade
    window auto hide
    with dissolve
    show bg workshop
    show trainer neutral at trainer_transform()
    trainer "Ok everyone, thanks for the lively discussions. Go enjoy a well-deserved afternoon of rest!"
    trainer "I’ll be going for a hike, if anyone wants to join me, meet me up at 2 at the entrance!"
    hide trainer
    $ renpy.music.stop(fadeout=2.0)
    scene black with fade
    jump day3wrap