label party:
    scene bg international

    $ renpy.music.play("audio/sweet-moments-chill-warm-hip-hop-216531.mp3", fadein=0.5, loop=True)

    show trainer happy at trainer_transform()
    play oneshots "audio/movement-101711.mp3"
    trainer "Welcome to the International Party, everyone!"
    trainer "Tonight is all about sharing who we are—our cultures, our passions, and maybe even our best dance moves!"
    trainer "Do you know the European Union’s motto, “United in Diversity”?"
    trainer "Let's celebrate everything that makes us unique and remember what brings us together."

    hide trainer

    show activist happy at activist_transform()
    play oneshots "audio/movement-101711.mp3"
    $ renpy.music.play("audio/traditional-greek-music-165000.mp3", fadein=1.0, loop=True)
    
    activist "Alright, everyone, time to shake things up!"
    activist "I'm going to teach you a traditional dance from my home country."
    activist "It's not just a dance—it's a celebration of resistance and unity."
    activist "In my culture, these movements have been used to bring people together, to protest, to stand up against injustice."

    transform activist_dance(xoffset=0, yoffset=0):
        subpixel True pos ((centerX + xoffset), (centerY + yoffset)) zoom 1 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 

    show activist partydance at activist_dance(0, -0.2)
    activist "Come on, don't be shy! It's not about getting the moves perfect; it's about feeling the rhythm and letting go."

    
    
    show party dance:
        xpos 0.47 zoom 0.65
    
    show party dance:
        subpixel True pos (0.14, 378) 


    transform camera_zoom:
        linear 2.0 zoom 1.5 xalign 0.5 yalign 0.5
        pause .3
        linear 2.0 zoom 1.0 xalign 0.5 yalign 0.5
        repeat


    camera:
        subpixel True
    
    camera at camera_zoom
    hide activist

    menu:
        "[[Join the Dance Enthusiastically]":
            $ activist_relation_value += 3
            show up arrow at up_arrow_anim(centerX,centerY,0,0)
            play oneshots "audio/wind-chime-small-64660.mp3"
            "Alright, show me how it's done!"
            hide activist 
            show activist happy at default, activist_transform(0, 1.1)
            activist "You know, sometimes activism isn't just about fighting—it's about celebrating what we're fighting for. Culture and community, that's what keeps us going."

        "Politely Decline and Observe":
            $ activist_relation_value += 1
            "I think I'll watch from here. But you're amazing at this!"

            hide activist 
            show activist neutral at default, activist_transform(0, 1.1)
            activist "You can't stay on the sidelines forever, you know. The dance floor always has room for one more."

        "Pfft, dancing is stupid, I don’t care.":

            # Characters' responses
            hide activist 
            show activist neutral at default, activist_transform(0.02, 1.1), zorder 2
            show down arrow at down_arrow_anim(centerX,centerY,0,0)
            play oneshots "audio/violin-lose-1-175615.mp3"
            activist "Whatever. Suit yourself, I’ll resist this negativity with my dance!"

            show punk neutral at punk_transform(0.2)
            punk "Don’t worry, I’ll join!"

            show trainer happy at trainer_transform(-0.41)
            trainer "Yeah!"

            show engineer happy at engineer_transform(-0.23), zorder 1
            engineer "Yeah!"

            show marketeer happy at marketeer_transform(-0.15)
            marketeer "Yeah!"

            show bestfriend neutral at bestfriend_transform(0.4)
            bestfriend "Come on, don’t be like that and join the dance!"

            hide trainer
            hide punk
            hide bestfriend
            hide engineer
            hide marketeer

    camera:
        subpixel True 
        linear 2.0 zoom 1.0 xalign 0.5 yalign 0.5
    
    hide activist
    hide party dance

    $ renpy.music.play("audio/sweet-moments-chill-warm-hip-hop-216531.mp3", fadein=0.5, loop=True)
    show punk dish at punk_transform()
    
    show punk dish:
        subpixel True ypos -0.03 zoom 1.61 


    play oneshots "audio/pot-of-water-boiling-54873.mp3"
    punk "So, this dish here is something I whipped up using ingredients straight from my eco-hostel's garden."
    punk "It's all homegrown, no artificial nonsense—just the good stuff, like my grandparents used to do."

    punk "I took over my grandparents' land to turn it into something self-sufficient."
    punk "It's not just about resisting consumerism; it's about creating a life that respects the land we live on."

    menu:
        "Compliment the Dish and Ask About the Eco-Hostel":
            "This tastes amazing, Riley! Tell me more about how you set up the eco-hostel."
            $ punk_relation_value += 3
            show up arrow at up_arrow_anim(centerX,centerY,0,0)
            play oneshots "audio/wind-chime-small-64660.mp3"
            hide punk dish
            show punk happy:
                pass
            show punk happy at punk_transform()
            punk "It wasn't easy, you know. Balancing my ideals with running a business... it's tough. But it feels good to know that every step I take is one away from the system I don't believe in."

        "Tease About Their Unexpected Cooking Skills":
            $ punk_relation_value += 1
            "Wow, didn't think you had this hidden talent, Riley! Are you secretly a chef?"
            punk "Don't go spreading that around. I've got a reputation to maintain. But yeah, I guess even punks need to eat, right?"

    
    hide punk


    play oneshots "audio/tappingmic-90213.mp3"
    show marketeer comedy at marketeer_comedy()
    marketeer "Okay, everyone! It’s already been a pretty intense week so far, right?"

    # Riley's response
    show punk neutral at punk_transform(0.3)
    punk "Yeah!"
    hide punk

    # Taylor continues
    marketeer "Yeah, broadening your horizons takes some effort."
    marketeer" Anyway, today I’m gonna showcase, exclusively for you, how I will create my next reel about this awesome youth exchange!"

    # Leo responds enthusiastically
    show trainer happy at trainer_transform(0.3)
    trainer "Woohoo!" 
    trainer "(claps)"
    hide trainer

    # Taylor, shifting to a neutral tone
    marketeer "Right! So, first things first, let’s choose the format."
    marketeer "I considered doing a “Get Ready With Me” video, but I felt like this didn’t fit the topic."

    # Alex giggles
    show engineer happy at engineer_transform(0.3)
    play oneshots "audio/small-giggle-85632.mp3"
    engineer "(giggles)"
    hide engineer

    # Taylor explains the chosen format
    marketeer "So, I’ll take the “5 things you didn’t know about…” structure."
    marketeer "You know, “5 things you didn’t know about cats,” “5 things you didn’t know about cooking tofu,” or whatever."
    

    # Jade responds
    show activist happy at activist_transform(-0.25)
    activist "Nice!"
    hide activist

    # Taylor, smiling
    marketeer "Thanks. So, in this reel, I’ll share my thoughts on our week so far. It’ll go:"
    marketeer "“5 things you didn’t know about climate and the EU”"
    marketeer "One: You will feel a bit lost if it’s your first travel, but you will be taken care of."

    # Leo laughs
    show trainer laughing at trainer_transform(-0.3)
    trainer "Hehe!"
    hide trainer

    # Taylor continues
    marketeer "Two: You will learn about all the things the EU is doing and how to get into action."

    # Jade comments
    show activist happy at activist_transform(-0.3)
    activist "So useful!"
    hide activist

    # Taylor's third point
    marketeer "Three: You will discover great food, like these green cupcakes I made."

    # Sam's response
    show bestfriend happy at bestfriend_transform(-0.3)
    bestfriend "Spinach and cream?"
    hide bestfriend

    # Taylor's fourth point, with Alex's reaction
    marketeer "Four: You will meet amazing people that challenge your views, and even get you into science."
    show engineer happy at engineer_transform(-0.3)
    play oneshots "audio/small-giggle-85632.mp3"
    engineer "(giggles)"
    hide engineer

    # Taylor's final point
    marketeer "And five: You won’t want to go home because you don’t want to leave any of them."

    # Player choice for interaction with Taylor
    menu:
        "Aww!":
            $ marketeer_relation_value += 1
            show up arrow as arrow at up_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/wind-chime-small-64660.mp3"
        
        "Eh.":
            $ marketeer_relation_value += 0
            show down arrow as arrow at down_arrow_anim(centerX, centerY, 0, 0)

            play oneshots "audio/violin-lose-1-175615.mp3"
    
    play oneshots "audio/crowd-clapping-100071.mp3"
    marketeer "So I’ll be making videos with each of you to make that reel! Thank you, and let’s now listen to Alex’s beautiful voice!"
    hide arrow
    # Everybody claps
    


    show bg international
    hide marketeer

    show engineer guitar at engineer_guitar()
    
    $ renpy.music.play("audio/the-beat-of-nature-122841.mp3", fadein=1, loop=True)

    "* Alex takes a guitar, and starts singing and strumming*"
    engineer "This is how I unwind after a day full of data and debates."
    engineer "Sometimes you need to let the music do the talking, you know?"
    engineer "It's my way of connecting with the human side of all this science."

    transform engineer_guitar_back:
        pos (381, 0.23) zoom 0.86 

    show engineer guitar at engineer_guitar_back(), zorder 2

    show party singing:
        xpos 0.47 zoom 0.65
    show party singing:
        subpixel True pos (0.14, 378) 
    show party singing:
        subpixel True pos (0.17, 405) yzoom 1.0 zoom 0.58
    show party singing zorder 1

    transform flag_wave:
        subpixel True
        xzoom 1.0
        yzoom 1.0
        rotate 0
        parallel:
            ease 1.5 xzoom 1.05
            ease 1.5 xzoom 0.95
            repeat
        parallel:
            ease 2.0 yzoom 1.05
            ease 2.0 yzoom 0.95
            repeat
        parallel:
            ease 1.0 rotate 2
            ease 1.0 rotate -2
            repeat
    
    show notes:
        subpixel True pos (459, -261) zoom 0.49 


    show notes at flag_wave
    "Soon enough, everybody sings along"



    menu:
        "Join in the Singing Enthusiastically":
            $ engineer_relation_value += 3
            show up arrow at up_arrow_anim(centerX,centerY,0,0)
            play oneshots "audio/wind-chime-small-64660.mp3"
            "Count me in, Alex! Let's keep the music going!"

            
            show engineer happy:
                subpixel True pos (273, 0.28) zoom 1.57 


            engineer "You've got a good voice! This right here, it's what reminds me why I do what I do — it's for people, not just the planet."

        "Ask Alex About Balancing Science and Art":
            $ engineer_relation_value += 1
            "I didn't know you had this musical side, Alex. How do you balance it with all the science?"

            show engineer neutral:
                subpixel True pos (273, 0.28) zoom 1.57 
            engineer "Music's the emotional counterweight to the logic."
            engineer "It reminds me that our work isn't just about solving problems; it's about making sure those solutions touch people's lives."

    play oneshots "audio/crowd-clapping-100071.mp3"
    $ renpy.music.stop(fadeout=2.0)

    hide notes with dissolve
    hide party singing with dissolve
    hide engineer with dissolve

    $ renpy.music.play("audio/the-soul-hip-hop-212540.mp3", fadein=0, loop=True)
    show trainer neutral at trainer_transform()
    stop oneshots fadeout 5.0

    trainer "You know, I've seen movements rise and fall over the years."
    trainer "People with all the passion in the world but not enough balance between their ideals and practicality."
    trainer "That's why I believe in equipping you all with the tools to create real change—no matter where you're coming from."

    menu:
        "Ask About Leo's Early Experiences":
            $ trainer_relation_value += 3
            show up arrow at up_arrow_anim(centerX,centerY,0,0)
            play oneshots "audio/wind-chime-small-64660.mp3"
            "What was it like when you started out, Leo? Did you always believe in compromise?"

            show trainer sad at trainer_transform()
            play oneshots "audio/movement-101711.mp3"
            trainer "Not always. I was stubborn, thought I could change the world on my own."
            show trainer happy at trainer_transform()
            play oneshots "audio/movement-101711.mp3"
            trainer "But life has a way of showing you that change doesn't happen in isolation."
            trainer "It happens when you listen, when you're willing to see things from someone else's perspective."
            trainer "That's what led me to believe in compromise—it's not about giving up; it's about finding a way forward together."

        "Share Your Thoughts on the Week So Far":
            $ trainer_relation_value += 1
            "This week has been intense, but also inspiring. It's hard to balance everyone's different ideas, though."

            show trainer neutral at trainer_transform()
            play oneshots "audio/movement-101711.mp3"
            trainer "It's not easy, is it? Bringing people with different passions and perspectives into alignment."
            trainer "But that's where the real growth happens."
            trainer "When you step out of your own comfort zone to meet others where they are, that's when you start building something that's truly sustainable."

        "Express Doubts About Making an Impact":
            $ trainer_relation_value += 2
            show up arrow at up_arrow_anim(centerX,centerY,0,0)
            play oneshots "audio/wind-chime-small-64660.mp3"
            "I'm not sure if I'm cut out for this. Can one person really make a difference?"

            show trainer neutral at trainer_transform()
            play oneshots "audio/movement-101711.mp3"
            trainer "Never underestimate the power of one person's actions."
            trainer "Change starts small, with a spark, and then it grows."
            trainer "You're already making an impact by being here, by caring."
            trainer "You're part of something bigger, and that's where real change begins."

    trainer "The truth is, every movement needs all kinds of people — the dreamers, the planners, the doers."
    trainer "You all bring something unique to the table, and that's what makes this so powerful."
    trainer "I believe in each of you, and I know that when we combine our strengths, we're unstoppable."

    show trainer happy at trainer_transform()
    play oneshots "audio/movement-101711.mp3"
    trainer "Alright, everyone, let's not forget to enjoy these moments."
    trainer "The debates and the discussions—they're important, but so is this."
    trainer "Tonight, let's celebrate how far we've come and how much we've learned from each other."
    trainer "Tomorrow, we'll get back to changing the world."


    $ renpy.music.stop(fadeout=2.0)
    scene black with fade

    show bg midnight with Dissolve(3.0)
    show bg morning with Dissolve(3.0)
    jump day4


    
   






