label day4:
    $ renpy.music.play("audio/lofi-study-calm-peaceful-chill-hop-112191.mp3", fadein=1.0, loop=True)
    window auto hide
    with dissolve
    show bg workshop

    play oneshots "audio/movement-101711.mp3"
    show presentation3 at presentation3
    show marketeer happy at marketeer_transform()
    marketeer "Okay everyone, today Leo’s giving me the floor!"
    marketeer "So buckle up, and listen carefully as I present some of the coolest action design tools and communication plans I’ve picked up along the way."

    # Taylor gets serious
    show marketeer neutral at marketeer_transform()
    marketeer "Before we start, I want to tell you about a principle that will help you do pretty much anything:"
    marketeer "it’ll help you not only communicate better, but also design your actions better, and lead activities and people better."
    marketeer "Yeah, it’s that important."

    # Taylor introduces the Golden Circle theory
    show marketeer happy at marketeer_transform()
    marketeer "That principle is called “the Golden Circle.”"
    marketeer "It's a theory by American leadership expert Simon Sinek that probably has been overused, but hey, it’s easy to understand and it works."
    marketeer "Jade, care to do the honors?"

    # Jade explains the Golden Circle theory
    show activist happy at activist_transform(0.3)
    activist "Sure!"
    show marketeer happy at marketeer_transform(-0.3)
    show activist happy at activist_transform()
    activist "So, the Golden Circle theory says that to get people on board of anything, you shouldn’t talk to them about what you’re doing or how,"
    activist "but you should start with why you and them would be doing it."

    # Taylor's example on car ads
    show marketeer neutral at marketeer_transform()
    show activist happy at activist_transform(0.3)
    marketeer "Take car ads, for instance."
    marketeer "They don’t tell you about how to drive a car, or what to use it for."
    marketeer "They don’t tell you: ‘go to your groceries faster’."
    marketeer "They make these big stories about who you, as a potential car buyer, are as a person."

    # Jade elaborates on the example
    show marketeer happy at marketeer_transform(-0.3)
    show activist happy at activist_transform()
    activist "Exactly: car ads target potential buyers by targeting their motivation."
    activist "Do you care about your family? Get this spacious and practical car!"
    activist "Want to show you’re rich and value the fine things in life? Get this luxury sedan!"
    activist "Are you the kind of person who wants to be ready for anything? Get this SUV to look sporty and modern!"
    activist "You’re a dynamic young person with a warm personality? Take this colourful city car!"

    # Taylor connects the example back to motivation
    show marketeer neutral at marketeer_transform()
    show activist happy at activist_transform(0.3)
    marketeer "What you can see from these examples is that although car ads tell you a bit about new features (what) and car performance (how),"
    marketeer "what they really focus on is your motivation: the reason why you should buy that car."

    # Jade relates it to activism
    show marketeer happy at marketeer_transform(-0.3)
    show activist happy at activist_transform()
    activist "It’s the same with any sort of activism."
    activist "A lot of meaningful and useful activities aren’t that interesting on their own, i.e., the ‘how’ and ‘what,’ but it’s their purpose, the ‘why,’ that makes them interesting."
    activist "I spent several afternoons just packing letters and petitions to Members of the National and European Parliament."
    activist "If you asked me whether I want to spend hours packing letters? Meh."
    activist "But if you ask whether I want to make citizens’ voices heard and show our commitment to environmental and climate change issues, hell yeah, I’ll do anything that helps!"

    # Leo’s response
    show marketeer happy at marketeer_transform(.15)
    show activist happy at activist_transform(0.35)
    show trainer happy at trainer_transform()
    trainer "Oh, I get it! It’s the same when you protest, right?"
    trainer "Standing outside under the cold rain for hours isn’t what motivated me, but putting pressure on local authorities to obtain a meeting was."

    # Jade agrees and opens the floor for more examples
    hide trainer
    show marketeer happy at marketeer_transform(-0.3)
    show activist happy at activist_transform()
    activist "Yes! Does anybody have other examples?"

    # Player choice for character responses
    menu:
        "I want to hear about Alex's experience":
            show engineer happy at engineer_transform()
            show marketeer happy at marketeer_transform(-0.3)
            show activist happy at activist_transform(0.3)
            engineer "I guess you could say the same about the time I spent weeks collecting samples to monitor turtle nesting habitat."
            engineer "On paper, it was fun: a few weeks on a kayak and on the beach in summer."
            engineer "But we were under the scorching sun, sticky from sunscreen and seawater."
            engineer "If it hadn’t been for a clear purpose, I wouldn’t have done it."

            
            show engineer happy at engineer_transform(-0.3)
            show marketeer happy at marketeer_transform()
            show activist happy at activist_transform(0.3)
            marketeer "That’s what got you into science, right?"

            
            show engineer happy at engineer_transform()
            show marketeer happy at marketeer_transform(-0.3)
            show activist happy at activist_transform(0.3)
            engineer "Yes, exactly. But now I don’t mind hands-on work as much as I used to: I know what it is for, and I am learning how to make a difference with science!"

            
            show engineer happy at engineer_transform(-0.3)
            show marketeer happy at marketeer_transform()
            show activist happy at activist_transform(0.3)
            marketeer "So cool…"

        "I want to hear about Riley's experience":
            
            show marketeer happy at marketeer_transform(-0.3)
            show punk neutral at marketeer_transform()
            show activist happy at activist_transform(0.3)
            punk "I guess… even before I decided to create the ecohostel, I knew about hard work as I helped on my grandparents’ farm sometimes."
            punk "Physically, mentally, it can be hard: you’re out under the elements, and I’ve seen animals die, regardless of the care we provided them. It is heartbreaking."
            punk "But, with experience, you start to see the bigger picture, and spending your days in the mud and in dust from improving the hostel isn’t that bad."
            punk "I know why I do it, so seeing it appear is a reward in itself."

            show marketeer happy at marketeer_transform(-0.3)
            show activist happy at activist_transform()
            show punk neutral at marketeer_transform(0.3)
            activist "Wow, you live that every day, don’t you?"

        "I want to hear about Sam's experience":
            show marketeer happy at marketeer_transform(-0.3)
            show bestfriend happy at bestfriend_transform()
            show activist neutral at activist_transform(0.3)
            bestfriend "So, back home I launched this informal study group about climate change for people our age."
            bestfriend "Now we’re structuring it a bit, but for the first 2 years, it really was just about meeting with other people and trying to figure out the whole thing."
            bestfriend "Nothing really precise."

            menu:
                "But it was open":
                    "I think that’s what helped people come."
                    "At least it’s what encouraged me to come!"

            bestfriend "Thanks! Yeah, our message was: ‘You’re curious about climate change, but you feel lost? Let’s figure it out together!’ So, pretty open."
            bestfriend "Of course some trolls came a few times: but most of them just saw people didn’t care about their criticisms, so they left."
            bestfriend "A few stuck around though: under that layer of anger, they were genuinely curious!"

            
            show marketeer happy at marketeer_transform(-0.3)
            show bestfriend happy at bestfriend_transform(0.3)
            show activist neutral at activist_transform()
            activist "Sounds nice! Confronting people who think differently is probably the most difficult thing."

    hide activist
    hide bestfriend
    hide punk
    hide engineer
    # Taylor wraps up the discussion
    show marketeer neutral at marketeer_transform()
    marketeer "Ok, thanks for sharing your experience!"
    marketeer "Now, we’re getting to the bulk of this workshop. Buckle up, I’m going to share all my communication secrets with you!"

    # Narration for Taylor's presentation and time passing
    scene black with fade
    tuto "[[Taylor spends some time presenting communication methods, tools, and past campaigns he has taken part in.]"
    show bg workshop
    show marketeer neutral at marketeer_transform()
    marketeer "Great, hope you survived the talk! The tools and methods I’ve shown you, they’re serious."
    marketeer "Like, they’re the real deal used even by big worldwide movements."
    marketeer "You know, the ones that make the most to protect our planet and environment!"


    hide marketeer
    show bg opposite
    
    show activist neutral at activist_transform(0.35)
    play oneshots "audio/movement-101711.mp3"
    activist "Taylor, I disagree." 
    activist "Grassroots movements have the power to ignite change, especially when people see the impact in their own communities." 
    activist "It's real, it's tangible, and that motivates them to act." 
    activist "There's something about local action that makes people feel like they're truly a part of something meaningful, like they have control over what's happening around them."
    
    hide activist
    show bg workshop


    show marketeer happy at marketeer_transform()
    play oneshots "audio/movement-101711.mp3"
    marketeer "Jade, I hear you on the local stuff, but let's be honest—real change comes when you hit the global stage." 
    marketeer "We need big plans and strong communication strategies to make a splash." 
    marketeer "If people don't see the movement on their screens, how will they ever join in?" 
    marketeer "It's not just about small wins; it's about creating a wave that can't be ignored."

    hide marketeer
    show bg opposite
    
    show activist angry at activist_transform(0.35)
    play oneshots "audio/movement-101711.mp3"
    activist "I get that, Taylor." 
    activist "Going global means reaching more people, making a larger impact." 
    activist "But sometimes, when we focus too much on big plans, it becomes abstract—like numbers on a screen." 
    activist "Local action lets people see the change right in front of them; it's personal, and that's what gets them involved."

  
    show punk sad at punk_transform(-0.4)
    play oneshots "audio/movement-101711.mp3"
    punk "Exactly, Jade. You can't beat the feeling of working with your own hands, seeing the results up close." 
    punk "I'm all for keeping it grassroots because that's where you actually bond with people over something real—not some far-off goal that feels like it's out of reach." 
    punk "You build a bird refuge, you can actually see the impact: the birds come back and have a safe nest." 
    punk "It's not just some data that was made by someone whose motivations aren't always clear."
  
    show engineer neutral2 at engineer_transform(-0.2)
    play oneshots "audio/movement-101711.mp3"
    engineer "True, local action is essential, but we can't ignore the power of scaling up." 
    engineer "Global initiatives are where science and technology come into play." 
    engineer "If we want to make a lasting impact on climate change, we need large-scale solutions, backed by data, that can be implemented worldwide." 
    engineer "The local level gets people involved, but it's the global scale that drives systemic change."

    show activist neutral at activist_transform(0.35)
    play oneshots "audio/movement-101711.mp3"
    activist "You're not wrong, Alex. Data and global strategies do play a crucial role, but how do we get people to buy into those ideas if they don't see how it relates to their lives?" 
    activist "People need to feel connected to the cause, like it's not just happening far away but right here, where they live."
    menu:
        
        "I get it. Local action is personal and powerful.":
            "I see where Jade and Riley are coming from."
            "People need to feel the change in their own lives to stay motivated."
            "Local action isn't just small—it's powerful because it's personal."
            $ activist_relation_value += 2
            $ punk_relation_value += 2
            $ marketeer_relation_value += 0
            
            hide activist
            hide punk
            hide marketeer
            show activist happy at activist_transform(0.35)
            show punk happy at punk_transform(-0.4)
            show marketeer sad at marketeer_transform()
            play oneshots "audio/movement-101711.mp3"
            show engineer neutral at engineer_transform(-0.2)

        "Taylor and Alex are right. We need to think bigger.":
            "Taylor and Alex have a point."
            "If we don't get our message out to the world, how can we expect to make a lasting impact?"
            "We need to think big and aim high."
            $ marketeer_relation_value += 2
            $ engineer_relation_value += 2
            $ activist_relation_value += 0
            $ punk_relation_value += 0
            
            hide engineer
            hide activist
            hide punk
            hide marketeer
            show engineer happy at engineer_transform(-0.2)
            show activist sad at activist_transform(0.35)
            show punk sad at punk_transform(-0.4)
            show marketeer happy at marketeer_transform()
            play oneshots "audio/movement-101711.mp3"

        "Why not combine both? Local passion, global reach.":
            "What if we combine these approaches?"
            "Use the power of grassroots action to spark local passion, but amplify it with global strategies that get everyone's attention."
            "Both sides strengthen each other."
            $ activist_relation_value += 1
            $ punk_relation_value += 1
            $ marketeer_relation_value += 1
            $ engineer_relation_value += 1

            hide engineer
            hide activist
            hide punk
            hide marketeer
            show engineer neutral at engineer_transform(-0.2)
            show activist neutral at activist_transform(0.35)
            show punk neutral at punk_transform(-0.4)
            show marketeer neutral at marketeer_transform()
            play oneshots "audio/movement-101711.mp3"

    hide punk
    hide activist
    hide engineer
    show bg workshop
    with Pause(2)
    show trainer happy at trainer_transform(0.17)
    play oneshots "audio/movement-101711.mp3"
    trainer "Alright, everyone, that was a fantastic discussion!"
    trainer "It's so inspiring to see all of you pushing each other to think bigger and dig deeper."
    trainer "This is exactly what this training is all about—bringing different perspectives together to find common ground."

    trainer "So, this afternoon, we'll all be working on fleshing out our project ideas."
    trainer "I want you to pair up, and you can give feedback to each other while you go through the tools that Taylor presented."
    trainer "You will change partners at each hour. To mark the end of each hour, I'll come in to force you to have a break."
    trainer "We'll go through last night's dance moves, to see if you remember them!"

    show trainer neutral at trainer_transform(0.17)
    play oneshots "audio/movement-101711.mp3"
    trainer "After all, all this thinking, analysing, planning, it's important, but it's tiring."
    trainer "I think it's a big issue in politics too: representatives don't have the time, nor always the willingness, to discuss ideas in depth to find a common solution."
    trainer "Here, we can do that. But, to make sure we don't hold grudges against each other and that we start with less tension on such important matters, some movement will help us get energised again and relax!"

    show trainer happy at trainer_transform(0.17)
    play oneshots "audio/movement-101711.mp3"
    trainer "So, let's get to it!"
    trainer "We'll have no conclusion of the day activity today, you'll be free to take a walk, a rest, work on your project idea, whatever floats your boat."
    trainer "Then, come back, have a nice dinner in each other's company — this week's almost over! — and come back tomorrow to tell us what your want to do when you go back home!"

    hide trainer
    scene black with fade
    
    show bg night with Dissolve(2.0)
    show bg midnight with Dissolve(2.0)
    show bg morning with Dissolve(2.0)
    
    jump end