# Then, use it in your script
label proposals:
    $ renpy.music.play("audio/winter-goodbye-186220.mp3", fadein=1.0, loop=True)
    window auto hide
    with dissolve
    show bg entrance

    $ relationships = {
        "activist": activist_relation_value,
        "punk": punk_relation_value,
        "engineer": engineer_relation_value,
        "marketeer": marketeer_relation_value
    }

    $ highest_relations = custom_max(relationships)

    if len(highest_relations) == 4:
        hide activist happy
        hide punk happy
        hide engineer happy
        hide marketeer happy

        show trainer happy at trainer_transform()
        play oneshots "audio/movement-101711.mp3"
        trainer "I've seen you grow so much over this week, and it's been incredible to watch."
        trainer "You've got this spark, this drive to connect with people in a way that's both inspiring and genuine."
        trainer "And I think you have what it takes to lead, to make a real difference." 
        trainer "How about joining me in facilitating future workshops?"
        trainer "We could guide others the way we've come together this week—turning ideas into real, actionable change."
        trainer "What do you think? Ready to inspire the next wave of changemakers?"
        menu:
            "I’d be honoured. We could organise another Erasmus+ Youth Exchange, but this time, together!":
                show trainer happy at trainer_transform()
                trainer "You’re the best!"

            "You hold me in high esteem. I guess I’ll have to do my best!":
                show trainer happy at trainer_transform()
                trainer "You’re the best!"

            "I’ll try and do an Erasmus+ close to you so I can stick around!":
                show trainer happy at trainer_transform()
                trainer "You’re the best!"

        # Surprise reaction
        show trainer surprised at trainer_transform()
        trainer "Oh! By the way, I didn’t tell you:"
        show trainer happy at trainer_transform()
        trainer "I got my internship at the European Commission, I’m super excited!"
    
        # Nested player choice after Leo’s announcement
        menu:
            "Wow!":
                show trainer happy at trainer_transform()
                trainer "Thanks! Have a safe trip home!"
    
            "Congrats!":
                show trainer happy at trainer_transform()
                trainer "Thanks! Have a safe trip home!"
    
            "Sounds perfect for you.":
                show trainer happy at trainer_transform()
                trainer "Thanks! Have a safe trip home!"

    else:
        if "activist" in highest_relations:
            show activist happy at activist_transform()
            play oneshots "audio/movement-101711.mp3"
            activist "I used to think the louder the protest, the bigger the impact."
            activist "But this week showed me that real power is in strategy—targeting actions that hit where they matter most."
            activist "I want to turn this campaign into something not just loud, but smart."
            activist "Like, I’ve often preached to the converted, but I need to make our voice heard by those in power."
            activist "And I need someone by my side who gets that."
            activist "What do you say? Will you help me turn this fire into real change?"
            menu:
                "Totally: we could organise an informal group for youth to gather their opinion, like Sam did at home. I can share that experience with you.":
                    show activist happy at activist_transform()
                    activist "Great idea! Glad we’re on the same page. Let’s keep in touch!"

                "Definitely: we could even work on a Youth Participation Activity. Make youth voices heard, loud and proud!":
                    show activist happy at activist_transform()
                    activist "Great idea! Glad we’re on the same page. Let’s keep in touch!"

                "Sounds awesome: maybe we could find another youth exchange on influencing politics?":
                    show activist happy at activist_transform()
                    activist "Great idea! Glad we’re on the same page. Let’s keep in touch!"


        if "punk" in highest_relations:
            hide activist happy

            show punk happy at punk_transform()
            play oneshots "audio/movement-101711.mp3"
            punk "You know, I never thought I'd be standing here asking anyone to join me in my project."
            punk "I've always been all about doing things my way, on my own terms."
            punk "But you… you've got this way of seeing things that's made me think bigger."
            punk "I'm expanding the eco-hostel and starting a rewilding project on the land, and I'd love it if you'd be part of it."
            punk "We can stay true to what matters while building something real, something that'll last."
            punk "Are you in?"
            menu:
                "Sounds like hard work, but you taught me that gives results. I’m eager to get the work done!":
                    show punk happy at punk_transform()
                    punk "I’d love that. We’re gonna make such a great team!"

                "Sounds great! I was looking for a place to do an Erasmus, I could look for opportunities in your country so I can stick around for a while.":
                    show punk happy at punk_transform()
                    punk "I’d love that. We’re gonna make such a great team!"

                "Sounds awesome: I could help you first by seeing how you could host a European Solidarity Corps volunteering activity!":
                    show punk happy at punk_transform()
                    punk "I’d love that. We’re gonna make such a great team!"


        if "engineer" in highest_relations:
            hide activist happy
            hide punk happy

            show engineer happy at engineer_transform()
            play oneshots "audio/movement-101711.mp3"
            engineer "You know, when I started this week, I thought the data alone would be enough to guide us."
            engineer "Just follow the numbers, and everything else will fall into place, right?"
            engineer "But I've realized it's not that simple."
            engineer "Science is a method—it gives us the map, but it doesn't tell us where to go." 
            engineer "I need someone who can help turn that map into a journey, someone who sees the human side of every calculation."
            engineer "Will you join me in this project?"
            engineer "Together, we'll take the data and turn it into something real, something that touches lives and creates lasting change."
            engineer "What do you think? Ready to be the bridge between the science and the story it tells?"
            menu:
                "Cool! We could look into internships at the Joint Research Center, or at the Research and Innovation Directorate - General of the European Commission!":
                    show engineer happy at engineer_transform()
                    engineer "Sounds perfect. Let’s have a call once we get home!"

                "Brilliant! Let’s do a group volunteering project in the European Solidarity Corps. We could have someone else on board, like… Taylor?":
                    show engineer happy at engineer_transform()
                    engineer "Sounds perfect. Let’s have a call once we get home!"

                "Perfect! Maybe we could look at Youth Participation Activities, see how we could bridge the gap between science, policy, and youth?":
                    show engineer happy at engineer_transform()
                    engineer "Sounds perfect. Let’s have a call once we get home!"


        if "marketeer" in highest_relations:
            hide activist happy
            hide punk happy
            hide engineer happy

            show marketeer happy at marketeer_transform()
            play oneshots "audio/movement-101711.mp3"
            marketeer "You know, I've always been about making noise, getting the message out there, making sure people can't ignore what's happening."
            marketeer "But with you, I feel like we could do more—make that noise actually mean something, make it stick." 
            marketeer "So, what do you say?"
            marketeer "Join me in turning this social media campaign into a movement that people can't ignore."
            marketeer "Let's amplify the right voices and make sure the message cuts through the noise."
            marketeer "Together, we'll make sure it's not just loud, but meaningful."

            menu:
                "Sure! I’ve just applied to DiscoverEU. If I get it, I’ll tour Europe and interview people working on climate change so you have material to communicate on. Deal?":
                    show marketeer happy at marketeer_transform()
                    marketeer "Sounds like a plan. Don’t be a stranger!"

                "Dude, let’s work on a Youth Participation Activity. Your project sounds cut out for it.":
                    show marketeer happy at marketeer_transform()
                    marketeer "Sounds like a plan. Don’t be a stranger!"

                "Alex would be if we volunteered as a group in the European Solidarity Corps. We could use it to communicate about what we do, and have local workshops too!":
                    show marketeer happy at marketeer_transform()
                    marketeer "Sounds like a plan. Don’t be a stranger!"


    scene bg entrance

    show bestfriend neutral at bestfriend_transform()
    play oneshots "audio/movement-101711.mp3"
    bestfriend "Wow, what a week, huh?"
    bestfriend "I never thought this whole thing would turn out to be so... intense."
    bestfriend "I signed up thinking it'd be a nice way to spend the holidays, but it ended up being so much more."

    menu:
        "I feel like I've grown.":
            $ bestfriend_relation_value += 3
            "I know what you mean."
            "I came here just because you talked me into it, but now, I feel like I've actually grown."
            "I didn't expect to meet people who'd make me question my own beliefs."

            show bestfriend happy
            play oneshots "audio/movement-101711.mp3"
            bestfriend "See? I knew dragging you here would be worth it!"
            bestfriend "You really opened up to these people, and it's been pretty cool watching you evolve this week."
            bestfriend "I am eager to see what you'll do with your new partner!"

        "It's been overwhelming.":
            $ bestfriend_relation_value += 2
            "It's been overwhelming, honestly."
            "All these ideas, all this passion—it's like everyone's ready to change the world tomorrow, and I'm still trying to catch up."

            show bestfriend neutral
            play oneshots "audio/movement-101711.mp3"
            bestfriend "I get it."
            bestfriend "But hey, change doesn't happen overnight."
            bestfriend "Even being willing to listen to all these different viewpoints is a big step forward."
            bestfriend "After some rest, I'm sure you'll come up with something!"

        "I am not sure.":
            $ bestfriend_relation_value += 1
            "I don't know if I'm totally sold on all of this yet."
            "I mean, I've met some incredible people, but I still feel like I'm on the fence about where I fit in."

            show bestfriend sad
            play oneshots "audio/movement-101711.mp3"
            bestfriend "That's okay."
            bestfriend "Finding your place in all this takes time."
            bestfriend "I think you're on the right path, though."
            bestfriend "Maybe you just haven't found the project that really clicks with you yet."
            bestfriend "Hey, let's go home, you'll figure it out."

    with dissolve  
    hide bestfriend

    
    
    show goodbyes:
        subpixel True pos (0.6, 1.09) zoom 0.71 

    show goodbyes:
        pos (0.25, 0.38) 




    tuto "Congratulations on finishing the game! Before you leave, we would like you to think about a few things."
    tuto "First, think about the different European programmes you could be interested in taking part in."

    # Short pause
    pause 1.0

    tuto "Got it? Great!"
    tuto "Now, think about what types of activities you would like to do."

    # Short pause
    pause 1.0

    tuto "Got an idea? Super!"
    tuto "And, finally, think about who could help you navigate the world of European programmes and policy."

    # Short pause
    pause 1.0

    tuto "Good job! If you don’t know, your first point of information is the {a=https://youth.europa.eu/_en} European Youth Portal{/a}."

    # Final message
    tuto "Thank you very much for playing this game, and good luck on your journey!"

    scene black with fade
    jump finalcredits
