label day1party:
    init python:
        marketeer_partyX = 0.32
        marketeer_partyY = 333

    transform marketeer_party:
        pos (marketeer_partyX, marketeer_partyY)
        zoom 0.85

    init python:
        trainer_partyX = 0.44
        trainer_partyY = 0.36

    transform trainer_party:
        pos (trainer_partyX, trainer_partyY)
        zoom 0.79

    
    init python:
        activist_partyX = 0.21
        activist_partyY = 0.35

    transform activist_party:
        pos (activist_partyX, activist_partyY) 
        yzoom 1.0 
        zoom 0.79

    init python:
        bestfriend_partyX = 0.08
        bestfriend_partyY = 360

    transform bestfriend_party:
        pos (bestfriend_partyX, bestfriend_partyY) 
        zoom 0.87

    init python:
        engineer_partyX = 0.67
        engineer_partyY = 0.32

    transform engineer_party:
        pos (engineer_partyX, engineer_partyY) 
        zoom 0.79

    init python:
        punk_partyX = 0.57
        punk_partyY = 280

    transform punk_party:
        pos (punk_partyX, punk_partyY) 
        zoom 0.90
    
    $ renpy.music.stop(fadeout=1.0)
    $ renpy.music.play("audio/hip-hop-249794.mp3", fadein=1, loop=False)
    $ renpy.music.queue("audio/seductive-chill-hip-hop-instrumental-hear-me-134134.mp3", fadein=1,loop=True)
    #$ renpy.music.play("audio/SandsofSerenity.mp3", fadein=2.0, loop=True)

    with fade
    show bg party:
        zoom 1.00
        pos (0.0, 0.0)
        

    show bestfriend happy at bestfriend_party
    show engineer happy at engineer_party
    show activist happy at activist_party
    show marketeer happy at marketeer_party
    show punk happy at punk_party
    
    show trainer happy at trainer_transform(), zorder 1
    play oneshots "audio/movement-101711.mp3"




    trainer "Hey everyone! So great to see all of you here. I’m Leo, your trainer for this week’s program, and I’m super pumped to dive into everything we’ve got planned!"
    trainer "Before we get started, I just wanted to say how excited I am about all the projects we’ll be working on."
    trainer "You’ll see soon enough I’m a big nerd of EU policy, but really, policy only matters if citizens decide to take action."
    trainer "It’s amazing to see you all joined this exhange to find a way to get involved."
    trainer "Also, it’s the first youth exchange I’m personally organising, so I’m super duper excited."

    trainer "But enough from me for now!"
    trainer "Let’s go around and introduce ourselves so we can all get to know each other a bit."
    trainer "Tell us your name and maybe something about why you’re here."
    trainer "Oh, and don’t hesitate to say what pronouns you’d like us to use, if you want!"

    hide trainer happy
    show trainer happy at trainer_party(), zorder 0
    play oneshots "audio/movement-101711.mp3"

    show bestfriend happy at bestfriend_transform(), zorder 1
    play oneshots "audio/movement-101711.mp3"
    bestfriend "Hey everyone, I’m Sam."
    bestfriend "I’ve been involved in a few local environmental projects back home, and I’m really excited to meet all of you and learn more about how we can make a bigger impact together."
    bestfriend "And my pronouns are “she/her”. Nice to meet you all!"
    bestfriend "This is my best friend, by the way. (Go ahead, introduce yourself!)"

    
    hide bestfriend 
    show bestfriend happy at bestfriend_party(), zorder 0
    play oneshots "audio/movement-101711.mp3"

    menu:

        "I’m just here to check things out and maybe learn a bit about what we can do to help with climate change.":
            $ bestfriend_relation_value += 1
            show up arrow as arrow1 at up_arrow_anim(bestfriend_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ engineer_relation_value += 0
            show engineer sad at engineer_party
            show down arrow as arrow2 at down_arrow_anim(engineer_partyX,0.25,0,0), zorder 2

            play oneshots "audio/violin-lose-1-175615.mp3"
            $ marketeer_relation_value += 1
            show up arrow as arrow3 at  up_arrow_anim(marketeer_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ activist_relation_value += 0
            show activist sad at activist_party
            show down arrow as arrow4 at down_arrow_anim(activist_partyX,0.25,0,0), zorder 2

            play oneshots "audio/violin-lose-1-175615.mp3"
            $ trainer_relation_value += 1
            show up arrow as arrow5 at up_arrow_anim(trainer_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ punk_relation_value += 0
            show punk sad at punk_party
            show down arrow as arrow6 at down_arrow_anim(punk_partyX,0.25,0,0), zorder 2

            play oneshots "audio/violin-lose-1-175615.mp3"

        "I’m super excited to be here. I really want to learn how to make a difference!":
            $ bestfriend_relation_value += 1
            show up arrow as arrow1 at up_arrow_anim(bestfriend_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ engineer_relation_value += 0
            show engineer sad at engineer_party
            show down arrow as arrow2 at down_arrow_anim(engineer_partyX,0.25,0,0), zorder 2

            play oneshots "audio/violin-lose-1-175615.mp3"
            $ marketeer_relation_value += 1
            show up arrow as arrow3 at  up_arrow_anim(marketeer_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ activist_relation_value += 1
            show up arrow as arrow4 at  up_arrow_anim(activist_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ trainer_relation_value += 1
            show up arrow as arrow5 at  up_arrow_anim(trainer_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ punk_relation_value += 0
            show punk sad at punk_party
            show down arrow as arrow6 at down_arrow_anim(punk_partyX,0.25,0,0), zorder 2

            play oneshots "audio/violin-lose-1-175615.mp3"

        "To be honest I followed Sam here, so I’m not sure what to expect, but I’m hoping to learn something useful. I’m looking forward to meeting all of you!":
            $ bestfriend_relation_value += 1
            show up arrow as arrow1 at up_arrow_anim(bestfriend_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ engineer_relation_value += 1
            show up arrow as arrow2 at up_arrow_anim(engineer_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ marketeer_relation_value += 1
            show up arrow as arrow3 at  up_arrow_anim(marketeer_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"
            $ activist_relation_value += 0
            show activist sad at activist_party
            show down arrow as arrow4 at  down_arrow_anim(activist_partyX,0.25,0,0), zorder 2

            play oneshots "audio/violin-lose-1-175615.mp3"
            $ trainer_relation_value += 0
            show trainer surprised at trainer_party
            show down arrow as arrow5 at  down_arrow_anim(trainer_partyX,0.25,0,0), zorder 2

            play oneshots "audio/violin-lose-1-175615.mp3"
            $ punk_relation_value += 1
            show up arrow as arrow6 at up_arrow_anim(punk_partyX,0.25,0,0), zorder 2

            play oneshots "audio/wind-chime-small-64660.mp3"


    tuto "[[Your answers influence other characters’ reactions and relation with you.]"
    
    hide arrow1
    hide arrow2
    hide arrow3
    hide arrow4
    hide arrow5
    hide arrow6
    
    show trainer happy at trainer_transform(), zorder 1
    play oneshots "audio/movement-101711.mp3"

    trainer "Great! Since you both started, let’s continue the round of introduction by going around the group. And up next is…"
    
    hide trainer 
    show trainer happy at trainer_party(), zorder 0
    play oneshots "audio/movement-101711.mp3"

    show marketeer happy at marketeer_transform(), zorder 1
    play oneshots "audio/movement-101711.mp3"

    marketeer "I’m Taylor! I study economics, but honestly, I’m more into building a good platform and helping people get their message out."
    marketeer "You know, you can have the best idea in the world, but if you can’t get people’s attention, what’s the point?"
    tuto "(he checks his phone briefly, smiling at the group)"
    marketeer "I’m a “he/him” guy."
    marketeer "Looking forward to seeing what everyone here is passionate about."
    
    hide marketeer
    show marketeer happy at marketeer_party(), zorder 0
    play oneshots "audio/movement-101711.mp3"

    
    hide punk 
    show punk happy at punk_transform(), zorder 1
    play oneshots "audio/movement-101711.mp3"
    punk "Name’s Riley, I use “they/them”."
    punk "I dropped out of agriculture school because they were too focused on productivity and using chemicals, and I opened an eco-hostel on my grandparents’ land."
    punk "It’s all about doing things yourself, from the ground up—no big corporations or government handouts."
    punk "I’m here to share what I’ve been working on and maybe pick up some ideas from you all."

    hide punk
    show punk happy at punk_party(), zorder 0
    play oneshots "audio/movement-101711.mp3"

    
    hide engineer 
    show engineer happy at engineer_transform(), zorder 1
    play oneshots "audio/movement-101711.mp3"
    engineer "I’m Alex. I study environmental engineering and I’m really interested in how we can use science to solve environmental issues."
    engineer "You know, real evidence-based solutions. I’m hoping we can bring some solid facts to the table and maybe come up with something concrete."
    engineer "You can use “she/her” for me!"
    engineer "Looking forward to hearing what everyone’s working on."

    hide engineer 
    show engineer happy at engineer_party(), zorder 0
    play oneshots "audio/movement-101711.mp3"

    
    hide activist 
    show activist happy at activist_transform(), zorder 1
    play oneshots "audio/movement-101711.mp3"
    activist "My name is Jade! I choose the pronoun “they”. I’m a member of several activist movements back home and abroad."
    activist "We need change, and we need it now! I’m here because I want to see real action."
    activist "The time for talking is over. We need  to actually do something urgently."

    hide activist 
    show activist happy at activist_party(), zorder 0
    play oneshots "audio/movement-101711.mp3"

    
    hide trainer 
    show trainer happy at trainer_transform(), zorder 1
    play oneshots "audio/movement-101711.mp3"
    trainer "Great! Thanks, everyone. This is going to be an amazing week, I can feel it already."
    trainer "Alright, I won’t keep you much longer tonight. Let’s just enjoy the fire, get to know each other a little better."
    trainer "If anyone wants to chat about EU initiatives, what we’ve got planned, or if you have any issues, come talk to me."
    trainer "Otherwise, just relax and enjoy the evening!"


    tuto "[[You have now met all the characters.]"
    tuto "[[Your answers have already started influencing how each character perceives you.]"
    tuto "[[From now on, each answer you give will influence your relationship with Taylor, Riley, Alex, Jade and Leo.]"
    tuto "[[Remember: everyone is taking part in this exhange to expand their views.]"
    tuto "[[At the end, the character you’ve helped the most will be the one you get the closest to.]"
    tuto "[[Sam is your best friend no matter your choices.]"
    tuto "[[Now, you have some time to meet up with the other participants.]"
    jump choiceWhoToTalk



label choiceWhoToTalk:
    hide trainer 
    hide engineer 
    hide activist 
    hide punk 
    hide marketeer 
    hide bestfriend

    menu:
        "I want to talk to..."

        "Alex":
            if engineer_talk_counter > 0:
                jump alex2
            else:
                jump alex

        "Jade" if activist_talk_counter <= 0:
            jump jade

        "Riley" if punk_talk_counter <= 0:
            jump riley

        "Taylor":
            if marketeer_talk_counter > 0:
                jump taylor2
            else:
                jump taylor

        "Leo" if trainer_talk_counter < 2:
            if trainer_talk_counter > 0:
                jump leo2
            else:
                jump leo

        "No one":
            jump noone

label alex:
    $ engineer_talk_counter += 1
    show engineer happy at engineer_transform()

    #Displaying taylor with giggles to tease romance
    show marketeer happy at marketeer_transform(0.3)
    play oneshots "audio/small-giggle-85632.mp3"
    
    engineer "Hey, what’s up? Had a nice trip?"

    # Player Choice: Responding to Alex's question about the trip
    menu:
        engineer "Hey, what’s up? Had a nice trip?"

        "Yeah, the train trip was alright.":
            $ engineer_relation_value += 2
            show up arrow as arrow at up_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show engineer happy at engineer_transform()
            engineer "Glad to hear it! I took the train as well, it was my first time boarding an overnight train. It was quite comfortable, actually! I’m glad they picked a place accessible by land."

        "We carpooled together with Sam. We picked and dropped some people along the way. It was quite fun!":
            $ engineer_relation_value += 1
            show engineer neutral at engineer_transform()
            engineer "Oh, you drove all the way?! That must have been quite the trip. I wish train was more affordable all over the continent. Purchasing power limits climate-friendly choices for some people."

        "We took the plane, we arrived in no time at all.":
            $ engineer_relation_value += 0
            show down arrow as arrow at down_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            show engineer sad at engineer_transform()
            engineer "Oh, ok. What a way to start a climate-friendly week… But I suppose there was no other option."


    # Alex concluding the conversation
    show engineer neutral at engineer_transform()
    engineer "Hey, sorry, I arrived early and I need to catch some zzz’s. See you tomorrow!"
    hide engineer
    hide marketeer
    hide arrow
    jump choiceWhoToTalk

label alex2:
    show engineer happy at engineer_transform()

    #Displaying taylor with giggles to tease romance
    show marketeer happy at marketeer_transform(0.3)
    play oneshots "audio/small-giggle-85632.mp3"
    
    tuto "She's busy talking with Taylor"

    hide engineer
    hide marketeer
    hide arrow
    jump choiceWhoToTalk


label taylor:
    $ marketeer_talk_counter += 1
    show engineer happy at engineer_transform(0.3)
    #Displaying taylor with giggles to tease romance
    show marketeer happy at marketeer_transform()
    play oneshots "audio/girl-laugh-6689.mp3"

    marketeer "Hey there! So, it’s a weird pickup line, but here goes: what’s the real reason you’re here? What do you do at home for the climate?"

    # Player Choice: Responding to Taylor's question about climate actions
    menu:
        "There’s nothing I can do at my level.":
            $ marketeer_relation_value += 0
            show down arrow as arrow at down_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            show marketeer sad at marketeer_transform()
            marketeer "Eh, not the answer I expected. Well, you’re here to challenge your view, aren’t you?"

        "I sort the trash at home.":
            $ marketeer_relation_value += 1
            show marketeer neutral at marketeer_transform()
            marketeer "I guess we all start somewhere. Haha, if trash is your thing, maybe we can go plogging together while we’re here?"

            # Nested Player Choice: Asking about plogging
            menu:
                "Definitely!":
                    pass
                "What’s 'plogging'?":
                    show marketeer neutral at marketeer_transform()
                    marketeer "That’s when you pick up the trash while jogging. I do it each Sunday and post about what I picked up to raise awareness about pollution."

        "I run a social media account on sustainable clothing.":
            $ marketeer_relation_value += 3
            show up arrow as arrow at up_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show marketeer happy at marketeer_transform()
            marketeer "No way, that’s so cool! I post about all the environmental and climate initiatives I go to, to show people it’s fun and important."
            marketeer "We’ll have so much to talk about this week!"

    # Taylor concluding the conversation
    show marketeer neutral at marketeer_transform()
    marketeer "Uff, it’s getting late, isn’t it? I’ll head off. See ya!"
    hide marketeer
    hide engineer
    hide arrow
    jump choiceWhoToTalk


label taylor2:
    show engineer happy at engineer_transform(0.3)
    #Displaying taylor with giggles to tease romance
    show marketeer happy at marketeer_transform()
    play oneshots "audio/girl-laugh-6689.mp3"

    tuto "He's busy talking with Alex"

    hide marketeer
    hide engineer
    hide arrow
    jump choiceWhoToTalk

label jade:
    $ activist_talk_counter += 1
    show activist happy at activist_transform()
    activist "Hi! Are you part of any associations or movements for the climate?"

    # Player Choice: Responding to Jade's question about climate involvement
    menu:
        "No, I don’t have time for it.":
            $ activist_relation_value += 0
            show down arrow as arrow at down_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            show activist afraid_surprised at activist_transform()
            activist "Well… I guess if you’re here, it’s a start then."

        "Yeah, my week-ends are so full!":
            $ activist_relation_value += 2
            show up arrow as arrow at up_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show activist happy at activist_transform()
            activist "I know, right? You gotta prioritise. Last Saturday I had to choose between a protest, a workshop on saving energy, and a youth city council meeting. It was rough."

        "I take part in an informal study group that Sam created for people our age.":
            $ activist_relation_value += 1
            show activist neutral at activist_transform()
            activist "Well, I need more action, but to each their own, I guess."

    hide activist
    hide arrow
    jump choiceWhoToTalk


label riley:
    $ punk_talk_counter += 1
    show punk neutral at punk_transform()
    punk "Hi. So, it’s your first time in an activity like this? Leo is super excited, but I’m a bit overwhelmed."

    # Player Choice: Responding to Riley's question about the experience
    menu:
        "I get it: it must be tough to be away from your land right?":
            $ punk_relation_value += 2
            show up arrow as arrow at up_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show punk neutral at punk_transform()
            punk "Yeah, I don’t even take many days off. There’s a lot to take care of, and I want to give back to the community in some way. I hope I learn that this week!"

        "It’s the first time I have no choice but to speak English, I hope I don’t get a bad headache!":
            $ punk_relation_value += 1
            show punk happy at punk_transform()
            punk "Haha, I get it. I live deep in the countryside, so not many foreigners come by! But I’d love to host eco retreats and get people to discover the farm."

        "I have no idea what to expect, I’ll just go with the flow.":
            $ punk_relation_value += 0
            show down arrow as arrow at down_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            show punk angry at punk_transform()
            punk "Hmpf, that’s disappointing. What are you even doing here?"

    # Riley concluding the conversation
    show punk neutral at punk_transform()
    punk "Look, I gotta bounce. I need to call my cousin, she’s handling everything back home. I want to know if everything’s ok. Bye!"

    hide punk
    hide arrow
    jump choiceWhoToTalk


label leo:
    $ trainer_talk_counter += 1
    show trainer happy at trainer_transform()
    trainer "Hey! Everything alright? You doing ok? Tell me if I can help with anything!"

    # Player Choice: Responding to Leo's friendly question
    menu:
        "I just hope I don’t get bored. I’m just here for the beach.":
            $ trainer_relation_value += 0
            show down arrow as arrow at down_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/violin-lose-1-175615.mp3"
            show trainer sad at trainer_transform()
            trainer "Ok… Well, I’ll do my best to entertain and make the week dynamic!"

        "I hope I get along with everyone.":
            $ trainer_relation_value += 1
            show trainer surprised at trainer_transform()
            trainer "Oh, it is your first youth exchange, after all! And first time abroad, if I’m correct? Well, don’t worry: bring your best self, and I’m sure everything will go swimmingly!"

        "I’ve been looking forward to this week!":
            $ trainer_relation_value += 2
            show up arrow as arrow at up_arrow_anim(centerX,centerY,0,0)

            play oneshots "audio/wind-chime-small-64660.mp3"
            show trainer happy at trainer_transform()
            trainer "Great! Hope it lives up to your expectations!"
    hide trainer
    hide arrow
    jump choiceWhoToTalk

label leo2:
    $ trainer_talk_counter += 1
    # Second part of the conversation with Leo
    show trainer neutral at trainer_transform()
    trainer "Yes?"

    # Player Choice: Asking Leo more questions
    menu:
        "You’ve been to many exchanges like this before?":
            show trainer happy at trainer_transform()
            trainer "Yes indeed! I love meeting new people and I’m just fascinated by all things related to Europe."
            trainer "I take all the opportunities I can get to travel as part of different programmes."
            trainer "I want to make this passion useful, this is why I decided to focus on international initiatives related to climate change."

        "Why do you love EU policy so much? Sounds boring.":
            show trainer neutral at trainer_transform()
            trainer "I guess it does sound boring, doesn’t it?"
            trainer "I’ll admit I am a nerd, but really, I think everybody would gain from knowing a bit more about how the EU works, and how it impacts our daily lives."

        "What do you do for a living?":
            show trainer happy at trainer_transform()
            trainer "I study political science and am currently doing a semester in Sweden as part of Erasmus+."
            trainer "Next year is the last of my Master’s degree, but I might postpone: I applied to the traineeship programme of the European Commission and I should have the answer at the end of the week!"

    "you : (yawn)"
    # Leo wrapping up the conversation
    show trainer happy at trainer_transform()
    trainer "Haha, looks like someone is tired! You’ve had a long day of travel, you should get some rest. See you tomorrow!"

    hide trainer
    hide arrow
    jump choiceWhoToTalk

label noone:    
    hide trainer 
    hide engineer 
    hide activist 
    hide punk 
    hide marketeer 
    hide bestfriend 

    show bestfriend happy at bestfriend_transform(), zorder 1
    play oneshots "audio/movement-101711.mp3"
    bestfriend "So, what do you think? Quite the group, huh? It’ll be interesting to see how everyone’s ideas clash or come together."

    menu:

        "Jade’s really intense. I wonder what kind of activitst actions they’ve been part of...":
            $ activist_relation_value += 1
            bestfriend "Yeah, they’ve definitely got a lot of fire. I bet they’ve been involved in some pretty wild stuff."

        "Alex seems super smart. I like the way she talk about science—it sounds practical.":
            $ engineer_relation_value += 1
            bestfriend "Yeah, she seems like the type who’s got everything planned out. I bet she'll have some useful ideas."

        "Taylor seems like she knows how to market a cause. Might be handy to have someone like that.":
            $ marketeer_relation_value += 1
            bestfriend "For sure. Taylor seems like the kind of person who knows how to sell anything."

        "Riley’s got that whole DIY thing going on. They seem really down-to-earth.":
            $ punk_relation_value += 1
            bestfriend "Yeah, Riley’s definitely got the real deal when it comes to living sustainably."

    
    bestfriend  " *yawn* Phew, I’m getting pretty tired. Shall we call it a night?"
    menu:

        "Sure":
            bestfriend  "Great. Bye everyone!"

    $ renpy.music.stop(fadeout=2.0)
    scene black with fade


    show bg night with Dissolve(2.0)
    show bg midnight with Dissolve(2.0)
    show bg morning with Dissolve(2.0)


    jump day2

