﻿# The script of the game goes in this file.
image bg morning = "images/bg morning.png"
image bg night = "images/bg night.png"
image bg midnight = "images/bg midnight.png"

image presentation1 = "images/presentation1.png"
image presentation2 = "images/presentation2.png"
image presentation3 = "images/presentation3.png"

style main_text:
    color "#ffffff"  # White color
    line_spacing 15  # Line spacing of 20 pixels
    size 20  # Font size


#Backgrounds transforms
transform aerial_shot_transform:
    zoom 1.11
    subpixel True blur 0.7 matrixcolor InvertMatrix(0.0)*ContrastMatrix(0.94)*SaturationMatrix(1.0)*BrightnessMatrix(-0.07)*HueMatrix(0.0) 


transform aerial_shot_pure:
    zoom 0


transform scrollbg:
    xanchor 0
    yanchor 0
    xpos 0
    ypos 0
    linear 2.0 xalign 1.0 yalign 1.0
    repeat

transform presentation2:
    subpixel True pos (588, 0.08) zoom 0.37

transform presentation3:
        subpixel True pos (640, 0.11) zoom 0.34 



# Declare characters used by this game. The color argument colorizes the
# name of the character.

define tuto = Character("", color="#5fb7ff")


define activist = Character(_("Jade"), color="#20fc03")
image activist neutral = "images/activist neutral.png"
image activist sad = "images/activist sad.png"
image activist angry = "images/activist angry.png"
image activist happy = "images/activist happy.png"
image activist afraid_surprised = "images/activist afraid_surprised.png"
transform activist_transform(xoffset=0, yoffset=0):
        subpixel True pos ((centerX + xoffset), (centerY + yoffset)) zoom 1.34 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 
transform activist_back:
        subpixel True pos (0.37, 0.34) zoom 0.41 blur 0.21 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.01)*BrightnessMatrix(0.0)*HueMatrix(0.0) 


define engineer = Character(_("Alex"), color="#fce803")
image engineer neutral = "images/engineer neutral.png"
image engineer happy = "images/engineer happy.png"
image engineer sad = "images/engineer sad.png"
image engineer afraid = "images/engineer afraid.png"
image engineer angry = "images/engineer angry.png"
image engineer surprised = "images/engineer surprised.png"
transform engineer_transform(xoffset=0, yoffset=0):
        subpixel True pos ((centerX + xoffset), (centerY + yoffset)) zoom 1.34 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 
transform engineer_transform2(xoffset=0, yoffset=0):
        subpixel True pos ((centerX + xoffset), (centerY + yoffset)) zoom 1.345 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 


transform engineer_guitar:
    subpixel True ypos 0.0 zoom 1.6 xpos 756 





transform engineer_back:
        subpixel True pos (0.37, 0.34) zoom 0.41 blur 0.21 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.01)*BrightnessMatrix(0.0)*HueMatrix(0.0) 




define bestfriend = Character(_("Sam"), color="#1ec742")
image bestfriend neutral = "images/bestfriend neutral.png"
image bestfriend sad = "images/bestfriend sad.png"
image bestfriend afraid = "images/bestfriend afraid.png"
image bestfriend happy = "images/bestfriend happy.png"
image bestfriend angry = "images/bestfriend angry.png"
image bestfriend surprised = "images/bestfriend surprised.png"
init python:
    centerX = 0.4
    centerY = 0.3


transform bestfriend_transform(xoffset=0):
        subpixel True pos ((centerX + xoffset), centerY) zoom 1.34 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 
transform bestfriend_back:
        subpixel True pos (0.37, 0.34) zoom 0.41 blur 0.21 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.01)*BrightnessMatrix(0.0)*HueMatrix(0.0) 




define marketeer = Character(_("Taylor"), color= "#fc3d03")
image marketeer neutral = "images/marketeer neutral.png"
image marketeer sad = "images/marketeer sad.png"
image marketeer afraid = "images/marketeer afraid.png"
image marketeer happy = "images/marketeer happy.png"
image marketeer angry = "images/marketeer angry.png"
image marketeer surprised = "images/marketeer surprised.png"
transform marketeer_transform(xoffset=0):
        subpixel True pos ((centerX + xoffset), centerY) zoom 1.34 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 


transform marketeer_neutralpose:
        subpixel True ypos 0.15 zoom 1.54 xpos 702 






transform marketeer_comedy:
        subpixel True pos (0.37, 0.12) zoom 1.57 



transform marketeer_back:
        subpixel True pos (0.37, 0.34) zoom 0.41 blur 0.21 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.01)*BrightnessMatrix(0.0)*HueMatrix(0.0) 


define trainer = Character(_("Leo"), color= "#fc3d03")
image trainer neutral = "images/trainer neutral.png"
image trainer sad = "images/trainer sad.png"
image trainer afraid = "images/trainer afraid.png"
image trainer happy = "images/trainer happy.png"
image trainer angry = "images/trainer angry.png"
image trainer surprised = "images/trainer surprised.png"
transform trainer_transform(xoffset=0):
        subpixel True pos ((centerX + xoffset), centerY) zoom 1.34 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 
transform trainer_back:
        subpixel True pos (0.37, 0.34) zoom 0.41 blur 0.21 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.01)*BrightnessMatrix(0.0)*HueMatrix(0.0) 

transform trainer_presentation1:
        subpixel True pos (0.405, -0.07) zoom 1.80

        


        




define punk = Character(_("Riley"), color= "#fc3d03")
image punk neutral = "images/punk neutral.png"
image punk sad = "images/punk sad.png"
image punk afraid = "images/punk afraid.png"
image punk happy = "images/punk happy.png"
image punk angry = "images/punk angry.png"
image punk surprised = "images/punk surprised.png"
transform punk_transform(xoffset=0):
        subpixel True pos ((centerX + xoffset), centerY) zoom 1.34 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 
transform punk_back:
        subpixel True pos (0.37, 0.34) zoom 0.41 blur 0.21 matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.0)*SaturationMatrix(1.01)*BrightnessMatrix(0.0)*HueMatrix(0.0) 

transform up_arrow_anim(x, y, xoffset=0, yoffset=0):
        pos ((x + 0.06 + xoffset), (y + 0.05 + yoffset))
        zoom 0.25
        linear 1.0 yoffset -20
        linear 1.0 alpha 0

transform down_arrow_anim(x, y, xoffset=0, yoffset=0):
        pos ((x + 0.06 + xoffset), (y + 0.05 + yoffset))
        zoom 0.25
        linear 1.0 yoffset 20
        linear 1.0 alpha 0



transform small_bounce:
    yoffset 0
    linear 0.3 yoffset -10  # Moves up slightly over 0.3 seconds
    linear 0.3 yoffset 0


transform tremble_effect:
    xoffset 0
    xzoom 1.0  # Normal size to start
    parallel:
        linear 0.05 xoffset -5  # Small move to the left
        linear 0.05 xoffset 5   # Small move to the right
        repeat 5                # Repeat the shake a few times
    linear 0.1 xzoom 1.02       # Slight zoom for a tightening effect
    linear 0.1 xzoom 1.0        # Return to normal size
      

transform soft_tremble:
    xoffset 0
    xzoom 1.0  # Normal size to start
    parallel:
        linear 0.1 xoffset -2  # Small move to the left
        linear 0.1 xoffset 2   # Small move to the right
        repeat 3               # Repeat the shake a few times
    linear 0.1 xzoom 1.01      # Slight zoom for a soft tightening effect
    linear 0.1 xzoom 1.0       # Return to normal size

transform strong_tremble:
    matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 
    xoffset 0
    parallel:
        linear 0.05 xoffset -8  # Move left quickly
        linear 0.05 xoffset 8   # Move right quickly
        repeat 2                # Repeat the shake only a few times
    linear 0.1 xoffset 0        # Reset to original position
    matrixcolor InvertMatrix(0.0)*ContrastMatrix(1.2)*SaturationMatrix(1.2)*BrightnessMatrix(0.06)*HueMatrix(0.0) 

transform breathing_effect:
    xzoom 1.0  # Normal size at the start
    yzoom 1.0

    linear 1.0 xzoom 0.98 yzoom 0.98  # Gradually "exhale" (shrink slightly)
    linear 1.0 xzoom 1.0 yzoom 1.0    # Gradually "inhale" (return to normal)

transform transparency(value = 1.0):
    alpha value  # Set transparency level (1.0 is fully opaque, 0.0 is fully transparent)

image blush_overlay = "trainer happy blush.png"
image blush_engineer_overlay = "engineer neutral blush.png"
image blush_marketeer_overlay = "marketeer happy blush.png"

transform fade_in_blush(value = 1.0):
    blur 6
    alpha 0.0                  # Start fully transparent
    linear 1.5 alpha value

init python:
    def get_character_displayable(character_name, emotion):
        displayable_name = f"{character_name} {emotion}"
        d = renpy.get_displayable('master', displayable_name)
        return d

    def get_displayable_Xposition(character_name, emotion):
        d = get_character_displayable(character_name, emotion)
        if d:
                placement = d.get_placement()
                xpos = placement[0]
                return xpos
        return None

    def get_displayable_Yposition(character_name, emotion):
        d = get_character_displayable(character_name, emotion)
        if d:
                placement = d.get_placement()
                ypos =  placement[1]
                return ypos
        return None

# Usage example:
# x, y = get_displayable_position('eileen')
# if x is not None and y is not None:
#     print(f"Character position: x={x}, y={y}")




init python:
        config.layers = [ 'master', 'transient', 'screens', 'overlay', 'back', 'front' ]
# Audio
init python:
    renpy.music.register_channel("ambient1", "sfx", loop=True)
    renpy.music.register_channel("ambient2", "sfx", loop=True)
    renpy.music.register_channel("oneshots", "sfx", loop=False)
    

init python:
    # style.button.hover_sound = "audio/melancholy-ui-chime-47804.mp3"
    style.button.activate_sound = "audio/taking_gear_backpack.mp3"

init python:
    import random
init python:
    dialogue_sounds = [
        "audio/bubble-sound-43207.mp3",
        "audio/mouth-bass-102317.mp3",
        "audio/mouth-bass-102317.mp3",
        "audio/infographic-pop-5-197872.mp3",
        "audio/infographic-pop-1-197868.mp3",
        "audio/infographic-pop-4-197870.mp3",
        "audio/infographic-pop-7-197874.mp3",
        "audio/infographic-pop-10-197877.mp3",
        "audio/happy-pop-2-185287.mp3",
    ]

    def random_dialogue_sound(event, **kwargs):
        if event == "show":
            renpy.sound.play(random.choice(dialogue_sounds))

    config.character_callback = random_dialogue_sound

init python:
    def custom_max(dictionary):
        if not dictionary:
            return []  # Return an empty list if the dictionary is empty

        max_value = max(dictionary.values())
        return [key for key, value in dictionary.items() if value == max_value]


# First, define a function to get the highest relationship value
define get_highest_relationship = renpy.curry(max)



default punk_talk_counter = 0
default trainer_talk_counter = 0
default activist_talk_counter = 0
default engineer_talk_counter = 0
default marketeer_talk_counter = 0
default bestfriend_talk_counter = 0

default discovereu_counter = 0
default training_counter = 0
default participation_counter = 0



default sessions_counter = 0
default punk_session_counter = 0
default trainer_session_counter = 0
default activist_session_counter = 0
default engineer_session_counter = 0
default marketeer_session_counter = 0
default bestfriend_session_counter = 0



default prez_counter = 0
default punk_prez_counter = 0
default activist_prez_counter = 0
default engineer_prez_counter = 0
default marketeer_prez_counter = 0
default bestfriend_prez_counter = 0


default gender = 0
default codeForLanguage = {'french': 'FR'}


init python:
    credits = ('Backgrounds', 'Airgoof'), ('Backgrounds', 'Dorktwerp'), ('Sprites and CG', 'Ballclown'), ('GUI', 'Cuddlywad'), ('Writing', 'Dorktwerp'), ('Writing', 'Fingerpookie'), ('Programming', 'Dorktwerp'), ('Music', 'Grumblemuck'), ('Music', 'Headwookum')
    credits_s = "{size=80}Credits\n\n"
    c1 = ''
    for c in credits:
        if not c1==c[0]:
            credits_s += "\n{size=40}" + c[0] + "\n"
        credits_s += "{size=60}" + c[1] + "\n"
        c1=c[0]
    credits_s += "\n{size=40}Engine\n{size=60}Ren'py\n6.15.7.374" #Don't forget to set this to your Ren'py version
    
init:
#    image cred = Text(credits_s, font="myfont.ttf", text_align=0.5) #use this if you want to use special fonts
    image cred = Text(credits_s, text_align=0.5)
    image theend = Text("{size=80}The end", text_align=0.5)
    image thanks = Text("{size=80}Thanks for Playing!", text_align=0.5)


# Define the splash screen
screen splash():
    # Add your splash image
    add "images/intro_visual_logos.png"

    # Optional: Add a timer to automatically proceed after a few seconds
    timer 3.0 action Jump("start")

# Define the splash label
label splashscreen:
    scene black
    with Pause(1)
    
    show screen splash
    with dissolve
    with Pause(2)
    
    hide screen splash
    with dissolve
    with Pause(1)
    
    return


transform time_transition(old, new):
    old
    alpha 1.0
    new with Dissolve(3.0, alpha=True)
    alpha 0.0

init python:
    _preferences.language = "french"

init -2:
    style say_thought:
        line_spacing 20
    style say_dialogue:
        line_spacing 20
    style choice:
        color "#FFFFFF"
        line_spacing 20
        

# The game starts here.
label start:
    
    style main_text  # Apply the main_text style

    $ renpy.music.set_volume(0.05, channel="ambient1")
    $ renpy.music.set_volume(0.3, channel="ambient2")
    $ renpy.music.set_volume(0.15, channel="music")
    $ renpy.music.set_volume(1.0, channel="oneshots")

    $ engineer_relation_value = 0
    $ marketeer_relation_value = 0
    $ activist_relation_value = 0
    $ bestfriend_relation_value = 0
    $ trainer_relation_value = 0
    $ punk_relation_value = 0
    #jump day1_arrival
    jump day1_arrival